<?php
/**
 * Template part for displaying the footer widgets
 *
 * @package kivicare
 */

namespace Kivicare\Utility;

$footer = kivicare()->get_footer_option();
if (empty($footer['value'])) {
    return;
}

global $wp_registered_sidebars;
?>
<div class="footer-top">
    <div class="container">
        <div class="row">
            <?php 
            foreach ($footer['value'] as $key => $item) :
                $sidebar_id = 'footer_' . ($key + 1) . '_sidebar';
                
                if (!is_active_sidebar($sidebar_id)) {
                    continue;
                }

                // Get widget alignment class
                $widget_class = $wp_registered_sidebars[$sidebar_id]['before_widget'] ?? '';
                $widget_class = trim(str_replace(
                    ['<div class="widget %2$s ', '">'],
                    '',
                    $widget_class
                ));
                ?>
                <div class="<?php echo esc_attr("{$item} {$widget_class}"); ?>">
                    <?php dynamic_sidebar($sidebar_id); ?>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>