<?php 
add_action( 'wp_enqueue_scripts', 'listeo_enqueue_styles' );
function listeo_enqueue_styles() {
    wp_enqueue_style( 'parent-style', get_template_directory_uri() . '/style.css',array('bootstrap','font-awesome-5','font-awesome-5-shims','simple-line-icons','listeo-woocommerce') );

}


 
function remove_parent_theme_features() {
   	
}
add_action( 'after_setup_theme', 'remove_parent_theme_features', 10 );

add_filter( 'submit_listing_form_fields', 'listeo_child_force_children_field', 25, 2 );
function listeo_child_force_children_field( $sections, $listing_type ) {
    if ( 'rental' !== $listing_type ) {
        return $sections;
    }

    if ( empty( $sections['basic_prices'] ) || ! is_array( $sections['basic_prices'] ) ) {
        return $sections;
    }

    if ( empty( $sections['basic_prices']['fields'] ) || ! is_array( $sections['basic_prices']['fields'] ) ) {
        $sections['basic_prices']['fields'] = array();
    }

    if ( isset( $sections['basic_prices']['fields']['_children'] ) ) {
        return $sections;
    }

    $sections['basic_prices']['fields']['_children'] = array(
        'label'       => __( 'Allowed Children', 'listeo_core' ),
        'type'        => 'checkbox',
        'tooltip'     => __( 'Shows the children picker inside the booking widget for rental listings.', 'listeo_core' ),
        'required'    => false,
        'placeholder' => '',
        'name'        => '_children',
        'class'       => '',
        'priority'    => 10,
        'render_row_col' => '3',
    );

    return $sections;
}

add_filter( 'get_post_metadata', 'listeo_child_default_children_meta', 10, 4 );
function listeo_child_default_children_meta( $value, $object_id, $meta_key, $single ) {
    if ( '_children' !== $meta_key ) {
        return $value;
    }

    if ( metadata_exists( 'post', $object_id, '_children' ) || ! listeo_child_listing_is_rental( $object_id ) ) {
        return $value;
    }

    return $single ? 'on' : array( 'on' );
}

function listeo_child_listing_is_rental( $post_id ) {
    if ( 'listing' !== get_post_type( $post_id ) ) {
        return false;
    }

    $listing_type = get_post_meta( $post_id, '_listing_type', true );
    if ( ! empty( $listing_type ) ) {
        return 'rental' === $listing_type;
    }

    $terms = get_the_terms( $post_id, 'listing_type' );
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
        foreach ( $terms as $term ) {
            if ( 'rental' === $term->slug ) {
                return true;
            }
        }
    }

    return false;
}


?>
