# PureCustomizer Framework

**A maintained fork of the Kirki Customizer Framework**

## Overview

PureCustomizer is a WordPress customizer framework forked from Kirki, providing continued support and maintenance while ensuring 100% backward compatibility with existing Kirki implementations.

## Why PureCustomizer?

- **Continued Support**: Kirki development has slowed down and contains PHP warnings/notices in newer PHP versions
- **100% Backward Compatibility**: Drop-in replacement for Kirki - no code changes needed
- **Active Maintenance**: Regular updates and bug fixes
- **Enhanced Stability**: Fixes for PHP 8+ compatibility issues

## Migration from Kirki

### For Theme Developers

1. **Install PureCustomizer** plugin
2. **Deactivate Kirki** plugin 
3. **No code changes required** - all existing Kirki code continues to work

### For End Users

1. Install PureCustomizer plugin
2. Deactivate Kirki plugin
3. All your customizer settings are preserved automatically

## Compatibility

PureCustomizer maintains full compatibility with:

- All Kirki field types
- All Kirki configuration options  
- All Kirki helper functions
- All Kirki classes and methods
- All existing themes using Kirki

## Code Examples

All existing Kirki code works without modification:

```php
// This continues to work exactly as before
Kirki::add_config( 'my_theme', array(
    'capability'    => 'edit_theme_options',
    'option_type'   => 'theme_mod',
) );

Kirki::add_field( 'my_theme', array(
    'type'        => 'color',
    'settings'    => 'my_color',
    'label'       => 'My Color',
    'section'     => 'my_section',
    'default'     => '#ffffff',
) );

// Function calls also work
$color = Kirki::get_option( 'my_theme', 'my_color' );
```

## Features

- 30+ Custom Control Types
- Automatic CSS Generation
- PostMessage Support
- Conditional Logic
- Typography Controls with Google Fonts
- Responsive Controls
- Repeater Fields
- And much more...

## Support

- **Documentation**: All original Kirki documentation applies
- **Issues**: Report issues specific to PureCustomizer fork
- **Migration Help**: Contact us if you need migration assistance

## License

MIT License - same as original Kirki framework

## Credits

This fork is based on the excellent work of the original Kirki Framework team. All credit for the core functionality goes to the original Kirki developers.
