<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link				// SMS Configuration
				array(
					'label'         => __('<i class="fa fa-cogs"></i> SMS Configuration', 'listeo_core'),
					'description'   => __('Basic SMS settings and OTP verification configuration', 'listeo_core'),
					'type'          => 'title',
					'id'            => 'sms_configuration_block'
				),https://themeforest.net/user/purethemes
 * @since      1.0.0
 *
 * @package    Listeo_Twilio_Sms
 * @subpackage Listeo_Twilio_Sms/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Listeo_Twilio_Sms
 * @subpackage Listeo_Twilio_Sms/includes
 * @author     Lukas Girek <contact@purethemes.net>
 */
class Listeo_Sms {


	/**
	 * The single instance of Listeo_Core.
	 * @var 	object
	 * @access  private
	 * @since 	1.0.0
	 */
	private static $_instance = null;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	private $notification;
	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'LISTEO_SMS_VERSION' ) ) {
			$this->version = LISTEO_SMS_VERSION;
		} else {
			$this->version = '1.0.0';
		}
		$this->plugin_name = 'listeo-sms';

		add_action('admin_menu', array($this, 'add_menu_item'));
		add_filter('listeo_settings_fields', array($this, 'sms_settings'),12,1);
		add_action('wp_ajax_nopriv_listeoajaxsendotpsms', array($this, 'send_otp'));
		add_action('wp_ajax_nopriv_listeoajaxsendotp', array($this, 'send_otp'));
		
		include('class-listeo-notifications.php');

		$this->notification = Listeo_Sms_Notification::instance();
	}

	
	public function send_otp()
	{
		$phone = $_POST['phone'];
		$otp = mt_rand(1000, 9999);

		$transient_key = 'otp_' . $phone; // Create a unique transient key
		delete_transient($transient_key); // Delete any existing transients
		set_transient($transient_key, $otp, 5 * MINUTE_IN_SECONDS); // Store OTP for 5 minutes
		$body  = get_option('listeo_otp_body', __('Hi, here is your verification code {otp} for {site_name}', 'listeo_core'));


		$tags 	= array(

			'{otp}',
			'{site_name}',
			'{site_url}',
		
		);

		$values  = array(
			$otp,
			get_bloginfo('name'),
			get_home_url(),
		);

		$message = str_replace($tags, $values, $body);

		$message = nl2br($message);
		$message = htmlspecialchars_decode($message, ENT_QUOTES);

		
		$status = $this->notification->send($phone, $message);
		$status = true;
		if($status){
			wp_send_json_success(array('message' => 'OTP sent successfully'));
		} else {
			wp_send_json_error(array('message' => 'OTP sending failed'));
		}
		
		
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Listeo_Twilio_Sms_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

	/**
	 * Main Listeo_Core Instance
	 *
	 * Ensures only one instance of Listeo_Core is loaded or can be loaded.
	 *
	 * @since 1.0.0
	 * @static
	 * @see Listeo_Core()
	 * @return Main Listeo_Core instance
	 */
	public static function instance($file = '', $version = '1.2.1')
	{
		if (is_null(self::$_instance)) {
			self::$_instance = new self($file, $version);
		}
		return self::$_instance;
	} // End instance ()



	public function add_menu_item()
	{

		add_submenu_page('listeo_settings', 'SMS Settings', 'SMS Settings', 'manage_options', 'listeo_settings&tab=sms_settings',  array($this, 'settings_page'));
	}

	public function settings_page()
	{
		echo "dupa";
	}

	public function sms_settings($settings)
	{
		
		$settings['sms_settings'] = array(
			'title'                 => __('<i class="fa fa-sms"></i> SMS Options', 'listeo_core'),
			// 'description'           => __( 'Settings for single listing view.', 'listeo_core' ),
			'fields'                => array(

				// SMS Configuration
				array(
					'label'         => __('<i class="fa fa-cogs"></i> SMS Configuration', 'listeo_core'),
					'description'   => __('Basic SMS settings and OTP verification configuration', 'listeo_core'),
					'type'          => 'title',
					'id'            => 'sms_config_block'
				),
				array(
					'label'      => __('Enable SMS notifications', 'listeo_core'),
					'description'      => __('Adding listings by users will require purchasing a Listing Package', 'listeo_core'),
					'id'        => 'enable_sms',
					'type'      => 'checkbox',
				),
				array(
                    'id'            => 'otp_status',
                    'label'         => __('Enable OTP verification for registration', 'listeo_core'),
                    'description'   => __('Enable phone number verification for user registration', 'listeo_core'),
                    'type'          => 'checkbox',
                ),
				array(
					'id'        => 'otp_body',
					'label'      => __('OTP message text', 'listeo_core'),
					'description' => __('Available tags are: {otp}, {site_name}, {site_url}', 'listeo_core'),
					'default'      => __('Hi, here is your verification code {otp} for {site_name}', 'listeo_core'),
					'type'      => 'textarea',
				),
				
				// SMS Providers
				array(
					'label'         => __('<i class="fa fa-cloud"></i> SMS Providers', 'listeo_core'),
					'description'   => __('Configure your SMS service provider settings and credentials', 'listeo_core'),
					'type'          => 'title',
					'id'            => 'sms_providers_block'
				),
				array(
					'label'      => __('Debug Mode', 'listeo_core'),
					'description'      => __('If debug mode is enabled all SMS will be saved in debug.log file in wp-content, system won\'t send any actual SMS', 'listeo_core'),
					'id'        => 'sms_debug',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Twilio Account SID', 'listeo_core'),
					'description'      => __('Your Twilio Account SID from your Twilio console', 'listeo_core'),
					'id'        => 'twilio_sid',
					'type'      => 'text',
				),
				array(
					'label'      => __('Twilio Auth Token', 'listeo_core'),
					'description'      => __('Your Twilio Auth Token from your Twilio console', 'listeo_core'),
					'id'        => 'twilio_auth_token',
					'type'      => 'text',
				),
				
				array(
					'label'      => __('Twilio Phone Number', 'listeo_core'),
					'description'      => __('A Twilio phone number you purchased at twilio.com/console', 'listeo_core'),
					'id'        => 'twilio_number',
					'placeholder' 		=> '+123456789',
					'type'      => 'text',
				),

				// array(
				// 	'label'      => __('SMS throttle', 'listeo_core'),
				// 	'description'      => __('Limit sending SMS to users', 'listeo_core'),
				// 	'id'        => 'sms_throttle',
				// 	'type'      => 'checkbox',
				// ),
				// array(
				// 	'label'      => __('SMS throttle offset', 'listeo_core'),
				// 	'description'      => __('Limit sending SMS to users', 'listeo_core'),
				// 	'id'        => 'sms_throttle_offset',
				// 	'type'      => 'text',
				// ),
				
				
				// Listing Notifications
				array(
					'label'         => __('<i class="fa fa-list-alt"></i> Listing Notifications', 'listeo_core'),
					'description'   => __('Configure SMS notifications for listing submissions, publications, and expiration events. Available tags: {user_name}, {user_mail}, {listing_date}, {listing_name}, {listing_url}, {site_name}, {site_url}', 'listeo_core'),
					'type'          => 'title',
					'id'            => 'listing_notifications_block'
				),
				array(
					'label'      => __('Enable notification about submitted listing', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_listeo_core_listing_submitted_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Submitted listing notification text', 'listeo_core'),
					'default'      => __('Hi {user_name}, there was listing submitted from your account', 'listeo_core'),
					'id'        => 'sms_listeo_core_listing_submitted_body',
					'type'      => 'textarea',
				),
				array(
					'label'      => __('Enable this notification also for Admin', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message to admin', 'listeo_core'),
					'id'        => 'sms_listeo_core_admin_listing_submitted_status',
					'type'      => 'checkbox',
				),
				
				// Expired Listing
				array(
					'label'      => __('Enable notification about expired listing', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_expired_listing_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __('Hi {user_name}, your listing has expired', 'listeo_core'),
					'id'        => 'sms_expired_listing_body',
					'type'      => 'textarea',
				),
				
				// Expiring Soon Listing
				array(
					'label'      => __('Enable notification about upcoming expiration of listing', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_expiring_soon_listing_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __('Hi {user_name}, your listing will expire in 5 days', 'listeo_core'),
					'id'        => 'sms_expiring_soon_listing_body',
					'type'      => 'textarea',
				),
				
				// Published Listing
				array(
					'label'      => __('Enable notification about publishing listing', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_published_listing_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __('Hi {user_name}, your listing was published', 'listeo_core'),
					'id'        => 'sms_published_listing_body',
					'type'      => 'textarea',
				),
				
				// Listing Review
				array(
					'label'      => __('Enable notification about new review listing', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_notify_owner_review_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}, There's new review added to your listing {listing_name}", 'listeo_core'),
					'id'        => 'sms_notify_owner_review_body',
					'type'      => 'textarea',
				),

				// Booking & Payment Notifications
				array(
					'label'         => __('<i class="fa fa-calendar-check"></i> Booking & Payment Notifications', 'listeo_core'),
					'description'   => __('Configure SMS notifications for booking workflow, payments, and customer communications. Available tags: {user_mail}, {user_name}, {booking_date}, {listing_name}, {listing_url}, {listing_address}, {listing_phone}, {listing_email}, {site_name}, {site_url}, {dates}, {details}, {user_message}, {service}, {client_first_name}, {client_last_name}, {client_email}, {client_phone}, {billing_address}, {billing_postcode}, {billing_city}, {billing_country}, {price}', 'listeo_core'),
					'type'          => 'title',
					'id'            => 'booking_notifications_block'
				),

				// Guest Booking Waiting Approval
				array(
					'label'      => __('Enable notification about booking waiting for approval', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_waiting_approval_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}, Thank you for your booking request on {listing_name} for {dates}. Please wait for confirmation and further instruction", 'listeo_core'),
					'id'        => 'sms_to_user_waiting_approval_body',
					'type'      => 'textarea',
				),

				// Guest Instant Approval
				array(
					'label'      => __('Enable notification about instant booking', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_instant_approval_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}, Thank you for your booking request on {listing_name} for {dates}. Please wait for confirmation and further instructions", 'listeo_core'),
					'id'        => 'sms_to_user_instant_approval_body',
					'type'      => 'textarea',
				),

				// Guest Free Booking Confirmed
				array(
					'label'      => __('Enable notification about free booking confirmation', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_free_confirmed_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! Thank you for your booking request on {listing_name} for {dates}. Please wait for confirmation and further instructions", 'listeo_core'),
					'id'        => 'sms_to_user_free_confirmed_body',
					'type'      => 'textarea',
				),

				// Guest Cash Payment Booking
				array(
					'label'      => __('Enable notification about booking paid in cash', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_pay_cash_confirmed_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! Your booking request on '{listing_name}' for {dates} was approved. See you soon!", 'listeo_core'),
					'id'        => 'sms_to_user_pay_cash_confirmed_body',
					'type'      => 'textarea',
				),

				// Owner New Booking
				array(
					'label'      => __('Enable notification about new booking', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_owner_new_reservation_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! There is new booking on '{listing_name}' for {dates}.", 'listeo_core'),
					'id'        => 'sms_to_owner_new_reservation_body',
					'type'      => 'textarea',
				),

				// Owner Instant Booking
				array(
					'label'      => __('Enable notification about new instant booking', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_owner_new_instant_reservation_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! There is new instant booking on '{listing_name}' for {dates}.", 'listeo_core'),
					'id'        => 'sms_to_owner_new_instant_reservation_body',
					'type'      => 'textarea',
				),

				// Guest Booking Cancellation
				array(
					'label'      => __('Enable notification about booking cancellation', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_canceled_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! Your booking on '{listing_name}' for {dates} was cancelled.", 'listeo_core'),
					'id'        => 'sms_to_user_canceled_body',
					'type'      => 'textarea',
				),

				// Owner Booking Cancellation
				array(
					'label'      => __('Enable notification about booking cancellation', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_owner_canceled_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}, The booking on '{listing_name}' for {dates} was cancelled.", 'listeo_core'),
					'id'        => 'sms_to_owner_canceled_body',
					'type'      => 'textarea',
				),

				// Guest Payment Waiting
				array(
					'label'      => __('Enable notification about booking waiting for payment', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_pay_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! The booking on '{listing_name}' for {dates} is waiting for your payment.", 'listeo_core'),
					'id'        => 'sms_to_user_pay_body',
					'type'      => 'textarea',
				),

				// Owner Payment Received
				array(
					'label'      => __('Enable notification about booking paid', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_owner_paid_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! The booking on '{listing_name}' for {dates} was paid.", 'listeo_core'),
					'id'        => 'sms_to_owner_paid_body',
					'type'      => 'textarea',
				),

				// Guest Payment Confirmation
				array(
					'label'      => __('Enable notification about booking paid', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_paid_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! The booking on '{listing_name}' for {dates} was paid.", 'listeo_core'),
					'id'        => 'sms_to_user_paid_body',
					'type'      => 'textarea',
				),

				// Payment Waiting (Duplicate)
				array(
					'label'      => __('Enable notification about booking waiting for payment', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'user_waiting_payment_sms_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! The booking on '{listing_name}' for {dates} is waiting for your payment.", 'listeo_core'),
					'id'        => 'user_waiting_payment_sms_body',
					'type'      => 'textarea',
				),

				// Upcoming Booking Reminder
				array(
					'label'      => __('Enable notification about upcoming booking', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_upcoming_booking_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! You have a booking on '{listing_name}' for {dates}. See you soon!", 'listeo_core'),
					'id'        => 'sms_to_user_upcoming_booking_body',
					'type'      => 'textarea',
				),

				// Review Reminder
				array(
					'label'      => __('Enable notification about booking review', 'listeo_core'),
					'description'      => __('Check this checkbox to enable sending this message', 'listeo_core'),
					'id'        => 'sms_to_user_review_reminder_status',
					'type'      => 'checkbox',
				),
				array(
					'label'      => __('Notification text', 'listeo_core'),
					'default'      => __("Hi {user_name}! How was your experience with '{listing_name}' for {dates}. Please share!", 'listeo_core'),
					'id'        => 'sms_to_user_review_reminder_body',
					'type'      => 'textarea',
				),
			),


		);

		return $settings;
	}



}
