<?php
if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * Elementor Integration for AI Review Highlights
 */
class AIRS_Elementor {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    private function __construct() {
        add_action( 'elementor/widgets/register', [ $this, 'register_widgets' ] );
        add_action( 'elementor/elements/categories_registered', [ $this, 'add_elementor_widget_categories' ] );
        add_action( 'elementor/frontend/after_register_styles', [ $this, 'register_widget_styles' ] );
    }

    /**
     * Register widget styles
     */
    public function register_widget_styles() {
        wp_register_style(
            'airs-frontend-styles',
            AIRS_PLUGIN_URL . 'assets/css/airs-styles.css',
            [],
            AIRS_VERSION
        );
    }

    /**
     * Register Elementor widgets
     */
    public function register_widgets() {
        // Make sure Elementor is loaded
        if ( ! did_action( 'elementor/loaded' ) ) {
            return;
        }

        require_once AIRS_PLUGIN_DIR . 'includes/elementor/class-airs-elementor-widget.php';
        \Elementor\Plugin::instance()->widgets_manager->register( new AIRS_Elementor_Widget() );
    }

    /**
     * Add custom Elementor widget categories
     */
    public function add_elementor_widget_categories( $elements_manager ) {
        $elements_manager->add_category(
            'airs-widgets',
            [
                'title' => __( 'AI Review Highlights', 'ai-review-summary' ),
                'icon' => 'fa fa-star',
            ]
        );
    }
}

/**
 * Check if Elementor is installed and active
 */
function airs_check_elementor() {
    if ( ! did_action( 'elementor/loaded' ) ) {
        return false;
    }
    return true;
}

/**
 * Initialize Elementor integration if available
 */
function airs_init_elementor() {
    if ( airs_check_elementor() ) {
        AIRS_Elementor::instance();
    }
}
add_action( 'plugins_loaded', 'airs_init_elementor' );
