# PureCustomizer Installation & Migration Guide

## Quick Start (For Listeo Theme Users)

### 1. Installation

1. Go to WordPress Admin → Plugins → Add New
2. Upload the `pure-customizer.zip` file
3. Activate PureCustomizer

### 2. Migration from Kirki (If Applicable)

If you currently have Kirki installed:

1. **Keep Kirki active** while installing PureCustomizer
2. **Install and activate PureCustomizer**
3. **Check that everything works** in Customizer
4. **Deactivate Kirki** plugin
5. **All settings are preserved** automatically

### 3. For New Installations

If you've never used Kirki:

1. Simply install and activate PureCustomizer
2. Your Listeo theme customizer options will work immediately

## Technical Details

### What Changes

- Plugin name: "Kirki" → "PureCustomizer"
- Text domain: "kirki" → "pure-customizer" 
- Constants: Added `PURE_CUSTOMIZER_*` versions alongside `KIRKI_*`
- All existing Kirki classes and functions remain available

### What Stays the Same

- All `Kirki::` method calls work exactly as before
- All theme customization settings are preserved
- All customizer controls and fields work identically
- No theme code changes required

## Compatibility Matrix

| Component | Status | Notes |
|-----------|--------|-------|
| Kirki::add_field() | ✅ Works | 100% compatible |
| Kirki::add_config() | ✅ Works | 100% compatible |
| Kirki::add_section() | ✅ Works | 100% compatible |
| Kirki::add_panel() | ✅ Works | 100% compatible |
| Kirki::get_option() | ✅ Works | 100% compatible |
| All field types | ✅ Works | All 30+ field types supported |
| CSS output | ✅ Works | Automatic CSS generation continues |
| PostMessage | ✅ Works | Live preview functionality maintained |
| Google Fonts | ✅ Works | Typography controls work as before |

## Troubleshooting

### Issue: Customizer settings disappeared
**Solution**: Make sure both Kirki and PureCustomizer are never active at the same time initially. Activate PureCustomizer first, then deactivate Kirki.

### Issue: PHP errors or warnings
**Solution**: This is exactly what PureCustomizer fixes! Make sure you're running the latest version.

### Issue: Theme not detecting customizer framework
**Solution**: The theme should automatically detect PureCustomizer. If not, make sure the plugin is activated and check for any custom detection code in your theme.

## For Developers

### Adding Fields (Same as Kirki)

```php
Kirki::add_field( 'listeo_theme', array(
    'type'        => 'color',
    'settings'    => 'accent_color',
    'label'       => esc_html__( 'Accent Color', 'listeo' ),
    'section'     => 'colors',
    'default'     => '#ff6b6b',
    'priority'    => 10,
    'transport'   => 'auto',
    'output'      => array(
        array(
            'element'  => ':root',
            'property' => '--accent-color',
        ),
    ),
) );
```

### Getting Values (Same as Kirki)

```php
$accent_color = Kirki::get_option( 'listeo_theme', 'accent_color' );
```

## Support

For PureCustomizer-specific issues, please contact Listeo support.

For general Kirki/customizer questions, the original Kirki documentation still applies.
