<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Events\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
class EventTypeContext extends InstanceContext {
    /**
     * Initialize the EventTypeContext
     *
     * @param Version $version Version that contains the resource
     * @param string $type A string that uniquely identifies this Event Type.
     */
    public function __construct(Version $version, $type) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['type' => $type, ];

        $this->uri = '/Types/' . \rawurlencode($type) . '';
    }

    /**
     * Fetch the EventTypeInstance
     *
     * @return EventTypeInstance Fetched EventTypeInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): EventTypeInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new EventTypeInstance($this->version, $payload, $this->solution['type']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Events.V1.EventTypeContext ' . \implode(' ', $context) . ']';
    }
}