/* ----------------- Start Document ----------------- */
(function($){
"use strict";

$(document).ready(function(){
  // Check if infinite scroll is enabled
  var infiniteScrollEnabled = (typeof listeo_core !== 'undefined' && listeo_core.infinite_scroll === 'on');
  var currentLoadPage = 1;
  // Preserve form when not refreshing page.

  if ($("#listeo_core-search-form").hasClass("ajax-search")) {
    $(".fullwidth-filters ").addClass("ajax-search");
  }

  // Initialize buttons on page load
  if ($("#listeo-listings-container").length) {
    // Get current page from pagination or default to 1
    var currentPage = 1;
    var paginationCurrent = $(".pagination li.current");
    if (paginationCurrent.length) {
      currentPage = parseInt(paginationCurrent.data("paged")) || 1;
    }

    // Check if there's a next page by looking at pagination
    var nextPageLink = $(".pagination li a").filter(function() {
      return $(this).parent().data("paged") === (currentPage + 1);
    });

    if (nextPageLink.length > 0 || infiniteScrollEnabled) {
      // Get the initial data via AJAX to show accurate count
      var results = $("#listeo-listings-container");
      var filter = $("#listeo_core-search-form");
      var data = filter.serializeArray();
      var style = results.data("style");
      var grid_columns = results.data("grid_columns");
      var per_page = results.data("per_page");
      var custom_class = results.data("custom_class");
      var order = results.data("orderby");

      // Add required parameters
      data.push({ name: "action", value: "listeo_get_listings" });
      data.push({ name: "page", value: currentPage });
      data.push({ name: "style", value: style });
      data.push({ name: "grid_columns", value: grid_columns });
      data.push({ name: "per_page", value: per_page });
      data.push({ name: "custom_class", value: custom_class });
      data.push({ name: "order", value: order });

      // Silent AJAX call to get next page count
      $.ajax({
        type: "post",
        dataType: "json",
        url: listeo_core.ajax_url,
        data: data,
        success: function (response) {
          if (response.has_more_pages) {
            // Always use the next_page_count from backend - it's calculated correctly
            var nextPageCount = response.next_page_count || 0;
            var buttonText = listeo_core.next_page_listings_text.replace('%d', nextPageCount);
            var nextPage = response.current_page + 1;

            var buttonHtml = '<div class="listeo-next-page-button" data-next-page="' + nextPage + '">' +
              '<span class="button-text">' + buttonText + '</span>' +
              '<i class="fa fa-arrow-right"></i>' +
              '</div>';
            $("#map-container").append(buttonHtml);

            // Also update Load More button if it exists and infinite scroll is enabled
            if (infiniteScrollEnabled) {
              var loadMoreButton = $('.listeo-load-more-button');
              if (loadMoreButton.length) {
                loadMoreButton.show(); // Make sure button is visible
                var loadMoreText = listeo_core.next_page_listings_text.replace('%d', nextPageCount);
                loadMoreButton.removeClass('loading').find('.button-text').text(loadMoreText);
                loadMoreButton.find('.loading-icon').hide();
              }
            }
          }
        }
      });
    }
  }

  // Add debounced blur event handler for location search
  var blurTimeout;
  var currentSearchRequest = null;
  
  // Make blurTimeout accessible globally for coordination with autocomplete
  window.blurTimeout = blurTimeout;
  $(document).on("blur", "#location_search", function () {
    // Clear any existing timeout
    clearTimeout(blurTimeout);
    
    // Debounce the search trigger by 300ms to prevent race conditions with autocomplete
    blurTimeout = setTimeout(function() {
      var target = $("div#listeo-listings-container");
      target.triggerHandler("update_results", [1, false]);
    }, 300);
    
    // Update global reference
    window.blurTimeout = blurTimeout;
  });
  $("#listeo-listings-container").on(
    "update_results",
    function (event, page, append, loading_previous) {
      var results = $("#listeo-listings-container");

      var filter = $("#listeo_core-search-form");
      var data = filter.serializeArray();
      
      // Handle dynamically added checkboxes that may not be captured by serializeArray
      filter.find('input[type="checkbox"]:checked').each(function() {
        var name = $(this).attr('name');
        var value = $(this).val();
        
        // If checkbox has no value attribute, use 'on' as default
        if (!value || value === '') {
          value = 'on';
        }
        
        // Check if this checkbox is already in the data array
        var exists = false;
        for (var i = 0; i < data.length; i++) {
          if (data[i].name === name) {
            // Update existing entry if value was empty
            if (!data[i].value || data[i].value === '') {
              data[i].value = value;
            }
            exists = true;
            break;
          }
        }
        
        // If not found, add it
        if (!exists && name) {
          data.push({ name: name, value: value });
        }
      });
      var style = results.data("style");
      var grid_columns = results.data("grid_columns");
      var tax_region = results.data("region");
      var tax_category = results.data("category");
      var tax_service_category = results.data("service-category");
      var tax_rental_category = results.data("rental-category");
      var tax_event_category = results.data("event-category");
      var tax_classifieds_category = results.data("classifieds-category");
      var _listing_type = results.attr("data-_listing_type");

      var tax_feature = results.data("feature");
      var per_page = results.data("per_page");
      var custom_class = results.data("custom_class");
      var order = results.data("orderby");

      data.push({ name: "action", value: "listeo_get_listings" });
      data.push({ name: "page", value: page });
      data.push({ name: "style", value: style });
      data.push({ name: "grid_columns", value: grid_columns });
      data.push({ name: "per_page", value: per_page });
      data.push({ name: "custom_class", value: custom_class });
      data.push({ name: "order", value: order });
      data.push({ name: "append", value: append ? "true" : "false" });
      if (_listing_type) {
        data.push({ name: "_listing_type", value: _listing_type });
      }

	  var mapBounds = filter.find(".map-bounds");
    if (mapBounds.length) {
      mapBounds.each(function () {
        data.push({
          name: $(this).attr("name"),
          value: $(this).val(),
        });
      });
    }
	
      var has_listing_category_search = false;
      var has_service_category_search = false;
      var has_rental_category_search = false;
      var has_event_category_search = false;
      var has_classifieds_category_search = false;
      var has_listing_feature_search = false;
      var has_region_search = false;

      $.each(data, function (i, v) {
        console.log();
        if (v.name.substring(0, 15) == "tax-listing_cat") {
          if (v.value) {
            has_listing_category_search = true;
          }
        }
        if (v.name.substring(0, 15) == "tax-listing_cat") {
          if (v.value) {
            has_listing_category_search = true;
          }
        }

        if (v.name.substring(0, 15) == "tax-listing_fea") {
          if (v.value) {
            has_listing_feature_search = true;
          }
        }
        if (v.name.substring(0, 9) == "tax-regio") {
          if (v.value) {
            has_region_search = true;
          }
        }
      });
      if (!has_region_search) {
        if (tax_region) {
          data.push({ name: "tax-region", value: tax_region });
        }
      }
      if (!has_listing_category_search) {
        if (tax_category) {
          data.push({ name: "tax-listing_category", value: tax_category });
        }
      }
      if (!has_listing_feature_search) {
        if (tax_feature) {
          data.push({ name: "tax-listing_feature", value: tax_feature });
        }
      }
      if (!has_rental_category_search) {
        if (tax_rental_category) {
          data.push({
            name: "tax-rental_category",
            value: tax_rental_category,
          });
        }
      }
      if (!has_event_category_search) {
        if (tax_event_category) {
          data.push({ name: "tax-event_category", value: tax_event_category });
        }
      }
      if (!has_classifieds_category_search) {
        if (tax_classifieds_category) {
          data.push({
            name: "tax-classifieds_category",
            value: tax_classifieds_category,
          });
        }
      }
      if (!has_service_category_search) {
        if (tax_service_category) {
          data.push({
            name: "tax-service_category",
            value: tax_service_category,
          });
        }
      }

      // Cancel any existing search request to prevent race conditions
      if (currentSearchRequest && currentSearchRequest.readyState !== 4) {
        currentSearchRequest.abort();
      }

      currentSearchRequest = $.ajax({
        type: "post",
        dataType: "json",
        url: listeo_core.ajax_url,
        data: data,
        beforeSend: function (xhr) {
          results.addClass("loading");
        },
        success: function (data) {
          results.removeClass("loading");

          // Handle append mode for infinite scroll
          if (append && infiniteScrollEnabled) {
            // Find the container with listings and append new content
            var listingsWrapper = $(results).find('.listings-container');
            if (listingsWrapper.length === 0) {
              // Fallback: append to the main results container
              var newContent = $(data.html).find('.listing-item, .listing-list-item, .col-lg-12.col-md-12, .col-lg-6.col-md-12, .col-lg-4.col-md-6, .col-lg-3.col-md-6');
              if (newContent.length > 0) {
                $(results).find('.row').append(newContent);
              } else {
                // For list views
                var newListings = $(data.html).find('.listing-list, .listing-list-item');
                if (newListings.length > 0) {
                  $(results).find('.listing-list').append(newListings.html());
                } else {
                  // Last resort: append everything except the loader
                  var htmlWithoutLoader = data.html.replace(/<div class="loader-ajax-container"[\s\S]*?<\/div>\s*<\/div>/g, '');
                  $(results).append(htmlWithoutLoader);
                }
              }
            } else {
              listingsWrapper.append($(data.html).find('.listing-item, .listing-list-item'));
            }

            // Update current page tracker
            currentLoadPage = data.current_page;

          } else {
            // Normal replacement mode
            $(results).html(data.html);
            currentLoadPage = data.current_page || 1;
          }

          // Only update pagination if not in infinite scroll mode
          if (!infiniteScrollEnabled) {
            $("div.pagination-container").html(data.pagination);
          } else {
            // Hide standard pagination when infinite scroll is enabled
            $("div.pagination-container").hide();
          }
          $(".numerical-rating").numericalRating();
          $(".star-rating").starRating();
          
          // Update or create the next page button inside map container
          if ($("#map-container").length) {
            var mapContainer = $("#map-container");
            var existingButton = mapContainer.find(".listeo-next-page-button");
            
            // Show button if there are more pages available
            if (data.has_more_pages) {
              // Always use the next_page_count from backend - it's calculated correctly
              var nextPageCount = data.next_page_count || 0;
              var buttonText = listeo_core.next_page_listings_text.replace('%d', nextPageCount);
              var nextPage = data.current_page + 1;

              if (existingButton.length) {
                // Update existing button
                existingButton.find(".button-text").text(buttonText);
                existingButton.data("next-page", nextPage);
              } else {
                // Create new button
                var buttonHtml = '<div class="listeo-next-page-button" data-next-page="' + nextPage + '">' +
                  '<span class="button-text">' + buttonText + '</span>' +
                  '<i class="fa fa-arrow-right"></i>' +
                  '</div>';
                mapContainer.append(buttonHtml);
              }
            } else {
              // Remove button if no next page
              existingButton.remove();
            }
          }

          // Update or remove Load More button in all cases (not just append mode)
          if (infiniteScrollEnabled) {
            if (data.has_more_pages) {
              var loadMoreButton = $('.listeo-load-more-button');
              if (loadMoreButton.length) {
                loadMoreButton.show(); // Make sure button is visible
                loadMoreButton.data('next-page', data.current_page + 1);
                var nextPageCount = data.next_page_count || 0;
                var buttonText = listeo_core.next_page_listings_text.replace('%d', nextPageCount);
                loadMoreButton.removeClass('loading').find('.button-text').text(buttonText);
                loadMoreButton.find('.loading-icon').hide();
              }
            } else {
              $('.listeo-load-more-button').hide();
            }
          }

          $("#listeo-listings-container").triggerHandler(
            "update_results_success",
            [data]
          );
            $(document).trigger("ajaxContentLoaded");
          if (listeo_core.map_provider == "google") {
            var map = document.getElementById("map");
            if (typeof map != "undefined" && map != null) {
              //	mainMap();
            }
          }
        },
        complete: function () {
          // Clean up the request reference when done (success or error)
          currentSearchRequest = null;
        }
      });
    }
  );
  $(document)
    .on(
      "change",
      ".sort-by-select .orderby, #listeo_core-search-form.ajax-search select, .ajax-search input:not(#location_search,#_price_range,.bootstrap-range-slider,.form-control,.ai-search-input)",
      function (e) {
        var target = $("div#listeo-listings-container");
        target.triggerHandler("update_results", [1, false]);
        //job_manager_store_state( target, 1 );
      }
    )
    .on("keyup", function (e) {
      if (e.which === 13) {
        e.preventDefault();
        $(this).trigger("change");
      }
    });
  $(".bootstrap-range-slider").on("slideStop", function () {
    var target = $("div#listeo-listings-container");
    target.triggerHandler("update_results", [1, false]);
  });
  // $( '#listeo_core-search-form.ajax-search input.location_search' ).change( function() {
  // 	var target   = $('div#listeo-listings-container' );
  // 	target.triggerHandler( 'update_results', [ 1, false ] );
  // 	//job_manager_store_state( target, 1 );
  // } );

  if ($("#listeo_core-search-form:not(.main-search-form)").length) {
    document.getElementById("listeo_core-search-form").onkeypress = function (
      e
    ) {
      var key = e.charCode || e.keyCode || 0;
      if (key == 13) {
        if ($("#location_search:focus").length) {
          return false;
        }
        var target = $("div#listeo-listings-container");
        target.triggerHandler("update_results", [1, false]);
        e.preventDefault();
      }
    };
  }

  $(document).on("click", "span.panel-disable,.slider-disable", function (e) {
    var results = $("#listeo-listings-container");
    results.triggerHandler("update_results", [1, false]);
  });

  //$(document).on('click', 'div.pagination-container a', function(e) {
  $("div.pagination-container.ajax-search").on("click", "a", function (e) {
    e.preventDefault();
    var results = $("#listeo-listings-container");
    var filter = $("#listeo_core-search-form");
    var page = $(this).parent().data("paged");
    console.log(page);
    if (page == "next") {
      var page = $(".pagination li.current").data("paged") + 1;
    }
    if (page == "prev") {
      var page = $(".pagination li.current").data("paged") - 1;
    }
    results.triggerHandler("update_results", [page, false]);

    $("body, html").animate(
      {
        scrollTop: $(
          ".fs-inner-container .search,#titlebar, .ajax-search,#map-container"
        ).offset().top,
      },
      600
    );

    return false;
  });

  var init_layout = $("#listeo-listings-container").data("style");

  if (init_layout == "list" || init_layout == "list_old") {
    $(".layout-switcher a").removeClass("active");
    $(".layout-switcher a.list").addClass("active");
  } else {
    $(".layout-switcher a:not(.list)").addClass("active");
  }

  $(".tax-listing_category #tax-listing_category").on("change", function (e) {
    var label = $(this).find(":selected").html();
    $(".page-title").html(label);
  });

  $(".layout-switcher").on("click", "a", function (e) {
    e.preventDefault();
      // var page = 1;
      var results = $("#listeo-listings-container");
     // results.triggerHandler("update_results", [page, false]);
    $(".layout-switcher a").removeClass("active");
    $(this).addClass("active");
    var layout = $(this).data("layout");
    
    results.data("style", layout);
    if(layout == 'grid') {
      // add class new-grid to #listeo-listings-container
      results.addClass("new-grid-layout-nl");
      results.removeClass("list-layout");
    } 
    if(layout == 'list' || layout == 'list_old') {
      // remove class new-grid from #listeo-listings-container
      results.removeClass("new-grid-layout-nl");
    }

    if (window.resetSlidersToFirst) {
      // Small delay to ensure layout has updated
      setTimeout(function () {
        resetSlidersToFirst();
      }, 50);
    }
  
  });

  // Next page button click handler
  $(document).on("click", ".listeo-next-page-button", function (e) {
    e.preventDefault();
    var nextPage = $(this).data("next-page");
    if (nextPage) {
      var results = $("#listeo-listings-container");

      // Check if infinite scroll is enabled - if so, use append mode like Load More
      var appendMode = (listeo_core.infinite_scroll === 'on');
      results.triggerHandler("update_results", [nextPage, appendMode]);

      // Only scroll to top if NOT in append mode (pagination behavior)
      if (!appendMode) {
        $("body, html").animate({
          scrollTop: $(
            ".fs-inner-container .search,#titlebar, .ajax-search,#map-container"
          ).offset().top,
        }, 600);
      }
    }
  });

  // Load More button click handler
  $(document).on("click", ".listeo-load-more-button", function (e) {
    e.preventDefault();
    var button = $(this);
    var nextPage = button.data("next-page");

    if (nextPage && !button.hasClass('loading')) {
      var results = $("#listeo-listings-container");

      // Show loading state without disabling button
      button.addClass('loading');
      button.find('.button-text').text('Loading...');
      button.find('.loading-icon').show();

      // Trigger update with append mode
      results.triggerHandler("update_results", [nextPage, true]);
    }
  });

  // ------------------ End Document ------------------ //
});

})(this.jQuery);
/**/