/**
 * Stats
 *
 * @since 1.8.24
 */
(function (window, undefined) {
  window.wp = window.wp || {};

  var document = window.document;
  var $ = window.jQuery;
  var wp = window.wp;
  var $document = $(document);

  /**
   * Log.
   * @since 2.7.0
   */
  listeoStats.log = function (stat) {
    
    wp.ajax.post("listeo_stat_" + stat, {
      post_id: listeoStats.post_id,
      stat: stat,
    });
  };

  /**
   * Log Apply Button Click.
   * @since 2.7.0
   */
  listeoStats.logButtonClick = function () {
    $("body").on("click", ".book-now.button", function (e) {
      var that = $(this);
      if (!that.hasClass("book-now_clicked")) {
        wp.ajax
          .post("listeo_stat_booking_click", {
            post_id: listeoStats.post_id,
            stat: "booking_click",
          })
          .done(function (data) {
            that.addClass("book-now_clicked");
            if (window.console && listeoStats.isDebug) {
              window.console.log(data);
            }
            return;
          })
          .fail(function (data) {
            if (window.console && listeoStats.isDebug) {
              window.console.log(data);
            }
            return;
          });
      }
    });
  };
  listeoStats.logContactClick = function () {
    $("body").on("click", ".send-message-to-owner", function (e) {
      var that = $(this);
      console.log(that);
      if (!that.hasClass("contact-now_clicked")) {
        wp.ajax
          .post("listeo_stat_contact_click", {
            post_id: listeoStats.post_id,
            stat: "contact_click",
          })
          .done(function (data) {
            that.addClass("contact-now_clicked");
            if (window.console && listeoStats.isDebug) {
              window.console.log(data);
            }
            return;
          })
          .fail(function (data) {
            if (window.console && listeoStats.isDebug) {
              window.console.log(data);
            }
            return;
          });
      }
    });
  };

  /***********************************
   * Wait for DOM ready.
   *
   * @since 2.7.0
   ***********************************/
  $document.ready(function () {
    $.each(listeoStats.stats, function (index, value) {
      switch (value) {
        case "booking_click":
          listeoStats.logButtonClick();
          break;
        case "contact_click":
          listeoStats.logContactClick();
          break;

        default:
          listeoStats.log(value);
      }
    });
  });
})(window);
