<!-- Location -->
<?php 
// if $data is not 

if (!empty($data)) {
	// extract $data as variables
	if(isset($data->show_title))
	{
		$show_title = $data->show_title;
	} else {
		$show_title = true;
	}
} else {
	$show_title = true;
}

$latitude = get_post_meta( $post->ID, '_geolocation_lat', true ); 
$longitude = get_post_meta( $post->ID, '_geolocation_long', true ); 
$address = get_post_meta( $post->ID, '_address', true ); 
$disable_address = get_option('listeo_disable_address');
if(!empty($latitude) && $disable_address) {
	$dither= '0.001';
	$latitude = (int) $latitude + (rand(5,15)-0.5)*$dither;
}
if(!empty($latitude)) :

	// New way (using the function):
	$icons = get_listing_marker_icons($post);
	
	$icon = $icons['icon'];
	$icon_svg = $icons['icon_svg'];
	$has_svg = $icons['has_svg'];
	
?>
<!-- Location -->
<div id="listing-location" class="listing-section">
	<?php if($show_title) { ?>
	<h3 class="listing-desc-headline margin-top-60 margin-bottom-30"><?php esc_html_e('Location','listeo_core'); ?></h3>
	<?php } ?>
	<div id="singleListingMap-container" class="<?php if($disable_address) { echo 'circle-point'; } ?> " >
		<div id="singleListingMap" data-latitude="<?php echo esc_attr($latitude); ?>" data-longitude="<?php echo esc_attr($longitude); ?>" data-map-icon="<?php echo esc_attr($icon); ?>" <?php if(isset($icon_svg)) { ?> data-map-icon-svg="<?php echo esc_attr($icon_svg); ?>"<?php } ?>></div>
		<?php if(get_option('listeo_map_provider') == 'google_not_valid_anymore') { ?><a href="#" id="streetView"><?php esc_html_e('Street View','listeo_core'); ?></a> <?php } ?>
		<?php if(!$disable_address) { ?>
		<a target="_blank" href="https://www.google.com/maps/dir/?api=1&destination=<?php echo esc_attr($latitude.','.$longitude); ?>" id="getDirection"><?php esc_html_e('Get Directions','listeo_core'); ?></a>
		<?php }?>
	</div>
</div>

<?php endif;  ?>

