<?php

/*
Plugin Name: WP All Import Listeo Add-On
Description: An add-on for importing Listing data to Listeo 
Version: 2.2
Author: Purethemes.net
*/

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

final class WP_All_Import_Listeo_Add_On
{
	protected static $instance;
	protected $add_on;
	protected $addon_name = 'WP All Import Listeo Add-On'; // Define the name of your add-on
	protected $addon_slug = 'wp_all_import_listeo'; // Define a unique add-on slug

	// Singleton pattern to ensure only one instance of the add-on is loaded
	public static function get_instance()
	{
		if (self::$instance === null) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	// Constructor to add the init hook
	protected function __construct()
	{
		add_action('init', array($this, 'init'));
	}

	public function init()
	{
		// Check for required classes and display an admin notice if not found
		if (!class_exists('PMXI_Plugin') || !class_exists('PMXI_RapidAddon')) {
			add_action('admin_notices', function () {
				echo 'WP All Import Listeo Add-Om requires WP All Import Pro to be installed and active.';
			});
			return;
		}

		// Check if the Twenty Twenty-Four theme is active


		// Initialize the add-on with its name and slug
		$this->add_on = new PMXI_RapidAddon($this->addon_name, $this->addon_slug);
		$this->wpai_setup_fields(); // Add fields to the add-on
		$this->add_on->set_import_function([$this, 'import']); // Set the import function

		$this->add_on->run(); // R
	}


	// Define the fields for the import template
	public function wpai_setup_fields()
	{


		$this->add_on->import_images('_listing_gallery', 'Listing Gallery', 'images', [$this, 'listing_gallery']);

		$this->add_on->add_options(
			$this->add_on->add_field('_address', 'Listing Address', 'text'),
			'Location Details',
			array(
				$this->add_on->add_field('_friendly_address', 'Listing Short Address', 'text'),
				$this->add_on->add_field('_geolocation_lat', 'Latitude', 'text'),
				$this->add_on->add_field('_geolocation_long', 'Longitude', 'text'),
				$this->add_on->add_field('_place_id', 'Google Maps Place ID', 'text'),
			)
		);


		$this->add_on->add_field('_listing_type', 'Listing Type', 'text');
		$this->add_on->add_field('_verified', 'Verified Listing', 'radio', array(
			'on' => 'on',
			'' => 'off'
		));
		$this->add_on->add_field('_featured', 'Featured Listing', 'radio', array(
			'on' => 'on',
			'' => 'off'
		));


		$this->add_on->add_field('_booking_status', 'Booking Status', 'radio', array(
			'on' => 'on',
			'' => 'off'
		));
		$this->add_on->add_field('_booking_link', 'External Booking Link', 'text');
		$this->add_on->add_field('_normal_price', 'Booking Price regular days', 'text');
		$this->add_on->add_field('_weekday_price', 'Booking Price weekend days', 'text');
		$this->add_on->add_field('_weekday_price', 'Booking Price weekend days', 'text');
		$this->add_on->add_field('_event_date', 'Event start date', 'text');
		$this->add_on->add_field('_event_date_end', 'Event end date', 'text');
		$this->add_on->add_field('_max_guests', 'Max number of guests', 'text');
		$this->add_on->add_field('listeo-avg-rating', 'Average Listing rating', 'text');




		$this->add_on->add_field('_price_min', 'Price Range - minimum', 'text');
		$this->add_on->add_field('_price_max', 'Price Range - maximum', 'text');
		$this->add_on->add_field('_phone', 'Phone', 'text');
		$this->add_on->add_field('_email', 'Email', 'text');
		$this->add_on->add_field('_email_contact_widget', 'Use it for contact widget', 'radio', array(
			'on' => 'on',
			'' => 'off'
		));


		$this->add_on->add_field('_website', 'URL', 'text');
		$this->add_on->add_field('_facebook', 'Facebook', 'text');
		$this->add_on->add_field('_twitter', 'Twitter', 'text');
		$this->add_on->add_field('_youtube', 'YouTube', 'text');
		$this->add_on->add_field('_instagram', 'Instagram', 'text');
		$this->add_on->add_field('_whatsapp', 'WhatsApp', 'text');
		$this->add_on->add_field('_video', 'Embedable Video link', 'text');
		$this->add_on->add_field('_slots_status', 'Slot Status (set to "On")', 'text');
		$this->add_on->add_field('_slots', 'Slots json', 'text');




		$days = array(
			'monday'	=> __('Monday', 'listeo_core'),
			'tuesday' 	=> __('Tuesday', 'listeo_core'),
			'wednesday' => __('Wednesday', 'listeo_core'),
			'thursday' 	=> __('Thursday', 'listeo_core'),
			'friday' 	=> __('Friday', 'listeo_core'),
			'saturday' 	=> __('Saturday', 'listeo_core'),
			'sunday' 	=> __('Sunday', 'listeo_core'),
		);


		foreach ($days as $key => $value) {
			$this->add_on->add_field('_' . $key . '_opening_hour', ucwords($key) . ' Opening Hour', 'text');
			$this->add_on->add_field('_' . $key . '_closing_hour', ucwords($key) . ' Closing Hour', 'text');
		}


		// Add FAQ field - this will handle the repeating structure
		$this->add_on->add_field('_faq_status', 'FAQ Status', 'radio', array(
			'on' => 'on',
			'' => 'off'
		));

		// Add FAQ field - this will handle the repeating structure
		$this->add_on->add_field(
			'_faq_list',
			'FAQ Items',
			'text',
			null,
			'Enter FAQ data as JSON format or pipe-separated values. 
        JSON format: [{"question":"Q1","answer":"A1"},{"question":"Q2","answer":"A2"}]
        Or pipe format: Q1|A1||Q2|A2 (use || to separate FAQ pairs, | to separate question from answer)'
		);

		// Alternative approach - separate fields for better UI
		$this->add_on->add_field(
			'_faq_questions',
			'FAQ Questions',
			'text',
			null,
			'Enter questions separated by ||'
		);
		$this->add_on->add_field(
			'_faq_answers',
			'FAQ Answers',
			'text',
			null,
			'Enter answers separated by || (must match order of questions)'
		);



		//import custom fields
		if (class_exists('Listeo_Core_Meta_Boxes')) {



			$services_details_list = Listeo_Core_Meta_Boxes::meta_boxes_service();
			$rental_details_list = Listeo_Core_Meta_Boxes::meta_boxes_rental();
			$event_details_list = Listeo_Core_Meta_Boxes::meta_boxes_event();
			$classifieds_details_list = Listeo_Core_Meta_Boxes::meta_boxes_classifieds();
		}
		if (isset($services_details_list['fields'])) :
			foreach ($services_details_list['fields'] as $detail => $value) {
				$this->add_on->add_field($value['id'], $value['name'], 'text');
			}
		endif;


		if (isset($rental_details_list['fields'])) :
			foreach ($rental_details_list['fields'] as $detail => $value) {
				$this->add_on->add_field($value['id'], $value['name'], 'text');
			}
		endif;


		if (isset($event_details_list['fields'])) :
			foreach ($event_details_list['fields'] as $detail => $value) {
				$this->add_on->add_field($value['id'], $value['name'], 'text');
			}
		endif;


		if (isset($classifieds_details_list['fields'])) :
			foreach ($classifieds_details_list['fields'] as $detail => $value) {
				$this->add_on->add_field($value['id'], $value['name'], 'text');
			}
		endif;

		// // In your import() function
		// $gallery_ids = get_post_meta($post_id, 'listing_gallery', true);
		// if (!empty($gallery_ids)) {
		// 	// Convert comma-separated string to array
		// 	if (!is_array($gallery_ids)) {
		// 		$gallery_ids = explode(',', $gallery_ids);
		// 	}

		// 	$gallery = [];

		// 	foreach ($gallery_ids as $id) {
		// 		$url = wp_get_attachment_url($id);
		// 		if ($url) {
		// 			$gallery[$id] = $url;
		// 		}
		// 	}

		// 	if (!empty($gallery)) {
		// 		update_post_meta($post_id, '_gallery', $gallery);
		// 	}
		// }
	}



	public function listing_gallery($post_id, $attachment_id, $image_filepath, $import_options)
	{


		// Log to debug file
		$log_entry = date('Y-m-d H:i:s') . " | Post ID: $post_id | Attachment ID: $attachment_id | Filepath: $image_filepath
";
		file_put_contents(WP_CONTENT_DIR . '/listeo-import-log.txt', $log_entry, FILE_APPEND);

		// Log to error log
		error_log("listing_gallery called for post ID: {$post_id}, attachment ID: {$attachment_id}, image file: {$image_filepath}");

		// Check attachment validity
		if (!$attachment_id || !wp_attachment_is_image($attachment_id)) {
			error_log("Invalid or non-image attachment for post ID {$post_id}");
			return;
		}

		$url = wp_get_attachment_url($attachment_id);
		error_log("Retrieved URL: " . $url);

		// Get the current gallery from post meta
		$gallery = get_post_meta($post_id, '_gallery', true);

		// If it's not an array, initialize it
		if (!is_array($gallery)) {
			$gallery = array();
		}

		if ($url) {
			$gallery[$attachment_id] = $url;
			update_post_meta($post_id, '_gallery', $gallery);
		}
	}


	// Import function to handle the actual data import
	public function import($post_id, $data, $import_options)
	{
		// all fields except for slider and image fields
		$fields = array(
			'_listing_expires',
			'_listing_type',
			'_opening_hours_status',
			'_verified',
			'_featured',
			'_booking_status',
			'_booking_link',
			'_slots_status',
			'_slots',
			'_event_tickets',
			'_normal_price',
			'_weekday_price',
			'_reservation_price',
			'_expired_after',
			'_count_per_guest',
			'_max_guests',
			'listeo-avg-rating',
			'_availability',
			'_address',
			'_friendly_address',
			'_geolocation_lat',
			'_geolocation_long',
			'_place_id',
			'_event_date',
			'_event_date_end',
			'_size',
			'_price_min',
			'_price_max',
			'_gallery_style',
			'_phone',
			'_email',
			'_email_contact_widget',
			'_website',
			'_facebook',
			'_twitter',
			'_youtube',
			'_instagram',
			'_whatsapp',
			'_area',
			'_rooms',
			'_bedrooms',
			'_bathrooms',
			'_area',
			'_rooms',
			'_video',
			'_faq_status',
			'_faq_list',
			'_faq_questions',
			'_faq_answers',
		);
		$services_details_list = Listeo_Core_Meta_Boxes::meta_boxes_service();
		$rental_details_list = Listeo_Core_Meta_Boxes::meta_boxes_rental();
		$event_details_list = Listeo_Core_Meta_Boxes::meta_boxes_event();
		$classifieds_details_list = Listeo_Core_Meta_Boxes::meta_boxes_classifieds();


		if (isset($services_details_list['fields'])) :
			foreach ($services_details_list['fields'] as $detail => $value) {
				$fields[] = $value['id'];
			}
		endif;


		if (isset($rental_details_list['fields'])) :
			foreach ($rental_details_list['fields'] as $detail => $value) {
				$fields[] = $value['id'];
			}
		endif;


		if (isset($event_details_list['fields'])) :
			foreach ($event_details_list['fields'] as $detail => $value) {
				$fields[] = $value['id'];
			}
		endif;


		if (isset($classifieds_details_list['fields'])) :
			foreach ($classifieds_details_list['fields'] as $detail => $value) {
				$fields[] = $value['id'];
			}
		endif;




		$days = listeo_get_days();
		foreach ($days as $key => $value) {
			$fields[] = '_' . $key . '_opening_hour';
			$fields[] = '_' . $key . '_closing_hour';
		}

		foreach ($fields as $field) {
			// Check if the field can be updated
			if (empty($data['ID']) || $this->add_on->can_update_meta($field, $import_options)) {
				// Update the custom field with the imported data
				if (array_key_exists($field, $data)) {
					update_post_meta($post_id, $field, $data[$field]);
				}
			}
		}
		$this->process_faq_data($post_id, $data, $import_options);
	}


private function process_faq_data($post_id, $data, $import_options)
{
    $faq_data = array();

    // Method 1: Handle JSON format FAQ data
    if (!empty($data['_faq_list'])) {
        $faq_input = $data['_faq_list'];
        
        // Try to decode as JSON first
        $json_data = json_decode($faq_input, true);
        if (json_last_error() === JSON_ERROR_NONE && is_array($json_data)) {
            $faq_data = $json_data;
        } else {
            // Handle pipe-separated format: Q1|A1||Q2|A2
            $faq_pairs = explode('||', $faq_input);
            foreach ($faq_pairs as $pair) {
                $qa = explode('|', $pair, 2);
                if (count($qa) === 2) {
                    $faq_data[] = array(
                        'question' => trim($qa[0]),
                        'answer' => trim($qa[1])
                    );
                }
            }
        }
    }
    
    // Method 2: Handle separate questions and answers fields
    elseif (!empty($data['_faq_questions']) && !empty($data['_faq_answers'])) {
        $questions = explode('||', $data['_faq_questions']);
        $answers = explode('||', $data['_faq_answers']);
        
        // Make sure we have matching numbers of questions and answers
        $count = min(count($questions), count($answers));
        
        for ($i = 0; $i < $count; $i++) {
            if (!empty(trim($questions[$i])) && !empty(trim($answers[$i]))) {
                $faq_data[] = array(
                    'question' => trim($questions[$i]),
                    'answer' => trim($answers[$i])
                );
            }
        }
    }

    // Save the processed FAQ data to match your template structure
    if (!empty($faq_data)) {
        update_post_meta($post_id, '_faq_list', $faq_data);
        
        // If FAQ data exists, set FAQ status to 'on' by default (unless explicitly set to off)
        if (empty($data['_faq_status']) || $data['_faq_status'] !== '') {
            update_post_meta($post_id, '_faq_status', 'on');
        }
    }
}
}

WP_All_Import_Listeo_Add_On::get_instance();



// GS 16/10/2018 add geocoding info using WP All Import post row processing hook (if WPAI plugin loaded)


add_action('pmxi_saved_post', 'listeo_do_geo_after_post_saved', 10, 1);


function listeo_do_geo_after_post_saved($post_id)
{
	// Check if automatic geocoding is enabled

	// Check if listing already has valid coordinates
	$existing_lat = get_post_meta($post_id, '_geolocation_lat', true);
	$existing_lng = get_post_meta($post_id, '_geolocation_long', true);
	
	if (!empty($existing_lat) && !empty($existing_lng)) {
		global $listeo_addon;
		//$listeo_addon->log('Skipping geocoding for post ' . $post_id . ' - coordinates already exist (lat: ' . $existing_lat . ', lng: ' . $existing_lng . ')');
		return; // Exit if coordinates already exist
	}

	// init variables
	global $listeo_addon;
	$address_used = null;
	$address1 = get_post_meta($post_id, '_friendly_address', true);
	$address2 = get_post_meta($post_id, '_address', true);
	$address3 = null;
	if (($pos = strpos($address1, ',')) !== false) {
		$address3 = substr($address1, $pos + 1); // truncate first line of address
	}
	$key = get_option('listeo_maps_api_server'); // google maps api key
	// if $key is not set, skip
	if (empty($key)) {
		//$listeo_addon->log('Skipping geocoding for post ' . $post_id . ' - Google Maps API key is not set');
		return; // Exit if API key is not set
	}
	$request = null;

	// Log that geocoding is starting
	//$listeo_addon->log('Starting geocoding for post ' . $post_id . ' (no existing coordinates found)');

	// request geocode info and extract location from json array. Try 3 times until google returns data.
	// 1st try with friendly address.
	// 2nd try with google maps address.
	// 3rd try with the first line of the friendly address removed.
	if (!empty($address1)) {
		$address_used = 'friendly address used';
		$request = get_google_api_request_data($address1, $key);
		if (empty($request) && !empty($address2)) {
			$address_used = 'google maps address used';
			$request = get_google_api_request_data($address2, $key);
			if (empty($request) && !empty($address3)) {
				$address_used = 'truncated friendly address used';
				$request = get_google_api_request_data($address3, $key);
				if (empty($request)) {
					$address_used = 'geocoding failed!';
				}
			}
		}
	}
	$json = wp_remote_retrieve_body($request);
	$data = json_decode($json);

	// populate lat and long
	if (!empty($data)) {
		foreach ($data->results as $results) {
			$latitude = $results->geometry->location->lat;
			$longitude = $results->geometry->location->lng;
			update_post_meta($post_id, '_geolocation_lat', $latitude);
			update_post_meta($post_id, '_geolocation_long', $longitude);
			$place_id = $results->place_id;
			update_post_meta($post_id, '_place_id', $place_id);
		}
	}
}


function get_google_api_request_data($address, $key)
{
	$request = wp_remote_get('https://maps.google.com/maps/api/geocode/json?address=' . urlencode($address) .
		'&key=' . urlencode($key) . '&sensor=false');
	if (is_wp_error($request)) {
		$request = null;
	}
	return ($request);
}