<?php
/**
 * Plugin Name:       AI Review Highlights
 * Plugin URI:        https://purethemes.net
 * Description:       Generates AI-powered review summaries for 'listing' post types by analyzing WordPress comments and Google Reviews.
 * Version:           1.3.0
 * Author:            PureThemes
 * Author URI:        https://purethemes.net/
 * License:           GPL-2.0-or-later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       ai-review-summary
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// Define constants
define( 'AIRS_VERSION', '1.3.0' );
define( 'AIRS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'AIRS_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

/**
 * The function that runs during plugin activation.
 * This is used to create the custom database table.
 */
function airs_activate() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'ai_review_summaries';
    $charset_collate = $wpdb->get_charset_collate();

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        listing_id bigint(20) UNSIGNED NOT NULL,
        summary_data longtext NOT NULL,
        created_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        updated_at datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
        PRIMARY KEY  (id),
        UNIQUE KEY listing_id (listing_id)
    ) $charset_collate;";

    require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
    dbDelta( $sql );
}
register_activation_hook( __FILE__, 'airs_activate' );


/**
 * Main plugin class.
 */
final class AI_Review_Summary {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    private function __construct() {
        $this->includes();
        $this->init_hooks();
    }

    private function includes() {
        require_once AIRS_PLUGIN_DIR . 'includes/class-airs-core.php';
        require_once AIRS_PLUGIN_DIR . 'includes/class-airs-admin.php';
        require_once AIRS_PLUGIN_DIR . 'includes/class-airs-frontend.php';
        require_once AIRS_PLUGIN_DIR . 'includes/class-airs-ajax.php';
        
        // Load Elementor integration
        require_once AIRS_PLUGIN_DIR . 'includes/class-airs-elementor.php';
    }

    private function init_hooks() {
        // Initialize classes
        AIRS_Admin::instance();
        AIRS_Frontend::instance();
        AIRS_Ajax::instance();
    }
}

// Instantiate the plugin
AI_Review_Summary::instance();