<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class AIRS_Frontend {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    private function __construct() {
        add_action( 'wp_enqueue_scripts', [ $this, 'enqueue_styles' ] );
        
        // Use Listeo's dedicated hook for displaying the summary
        add_action( 'listeo/single-listing/after-content', [ $this, 'display_summary_card' ] );
    }

    public function enqueue_styles() {
        // Only load on single listing pages
        if ( is_singular( 'listing' ) ) {
            wp_enqueue_style( 'airs-frontend-styles', AIRS_PLUGIN_URL . 'assets/css/airs-styles.css', [], AIRS_VERSION );
        }
    }

    /**
     * Display AI review summary using Listeo's dedicated hook
     */
    public function display_summary_card() {
        // Only on single listing pages
        if ( ! is_singular( 'listing' ) ) {
            return;
        }

        global $post;
        
        $options = get_option('airs_settings');
        $show_description = isset($options['show_description']);
        $summary_title = isset($options['summary_title']) ? $options['summary_title'] : '✨ AI-Powered Review Summary';
        $hide_threshold = isset($options['hide_threshold']) ? intval($options['hide_threshold']) : 3;
        
        global $wpdb;
        $table_name = $wpdb->prefix . 'ai_review_summaries';
        
        $summary_row = $wpdb->get_row( $wpdb->prepare( "SELECT summary_data FROM $table_name WHERE listing_id = %d", $post->ID ) );

        if ( ! $summary_row || empty( $summary_row->summary_data ) ) {
            return; // No summary found
        }
        
        $summary_data = json_decode( $summary_row->summary_data, true );

        if ( ! isset($summary_data['summaries']) || empty($summary_data['summaries']) ) {
            return;
        }

        // Count negative points
        $negative_count = 0;
        foreach ( $summary_data['summaries'] as $item ) {
            if ( isset($item['sentiment']) && $item['sentiment'] === 'negative' ) {
                $negative_count++;
            }
        }

        // Hide summary if negative points exceed threshold
        if ( $negative_count > $hide_threshold ) {
            return;
        }

        ?>
        <div id="ai-review-summary-section" class="ai-review-summary-container">
            <h3>
                <?php echo wp_kses_post( $summary_title ); ?>
            </h3>
            <span class="line"></span>
            <div class="clearfix"></div>
            
            <div class="airs-summary-grid">
                <?php foreach ( $summary_data['summaries'] as $item ) : ?>
                    <?php
                    $card_class = 'airs-summary-card airs-sentiment-' . esc_attr($item['sentiment']);
                    if ( ! $show_description ) {
                        $card_class .= ' airs-title-only';
                    }
                    ?>
                    <div class="<?php echo $card_class; ?>">
                        <div class="airs-card-icon">
                            <?php if ($item['sentiment'] === 'positive') : ?>
                                
                            <?php else : ?>
                                
                            <?php endif; ?>
                        </div>
                        <div class="airs-card-content">
                            <h4><?php echo esc_html( $item['title'] ); ?></h4>
                            <?php if ( $show_description ) : ?>
                                <p><?php echo esc_html( $item['description'] ); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}