# Listeo iCal Admin Manager

Advanced admin management plugin for Listeo iCal imports/exports. Provides comprehensive oversight, bulk operations, and import history for all listings with iCal functionality.

## 📋 Overview

This plugin extends the Listeo Core iCal functionality by adding a powerful admin interface that allows administrators to:

- **Monitor all iCal imports** across the entire site
- **Perform bulk operations** on multiple listings
- **View detailed import history** and logs
- **Preview iCal content** before importing
- **Configure advanced settings** for performance and security
- **Health check** iCal imports for issues

## 🚀 Features

### 📊 Listings Overview
- **Complete listing table** showing all listings with iCal data
- **Status indicators** for import health and activity
- **Quick actions** for individual listings
- **Search and filter** capabilities
- **Bulk selection** and operations

### 🔧 Individual Listing Management
- **Detailed listing view** with all iCal imports
- **Force update** individual or all imports
- **Preview functionality** to see what will be imported
- **Remove imports** with associated booking cleanup
- **Recent import history** for each listing

### 📈 Import History & Logging
- **Comprehensive import history** with full details
- **Filter by status, type, date range**
- **Export history** to CSV for analysis
- **Automatic cleanup** of old records
- **Error tracking** and debugging information

### ⚙️ Advanced Settings
- **Performance tuning** (batch sizes, timeouts, memory limits)
- **Security controls** (allowed domains, rate limiting)
- **Logging configuration** (retention, detail levels)
- **System status** monitoring
- **Maintenance tools** and health checks

### 🔄 Bulk Operations
- **Force update all** imports across multiple listings
- **Preview all imports** to check content
- **Export/import settings** for backup and migration
- **Health check** to identify broken imports
- **Progress tracking** for long-running operations

## 📦 Installation

### Prerequisites
- WordPress 5.0 or higher
- PHP 7.4 or higher
- **Listeo Core plugin** must be active
- Sufficient memory (512MB+ recommended for bulk operations)

### Installation Steps

1. **Upload the plugin** to `/wp-content/plugins/listeo-ical-admin/`
2. **Activate the plugin** through WordPress admin
3. **Navigate to** "iCal Manager" in the admin menu
4. **Configure settings** under iCal Manager → Settings

## 🎯 Usage Guide

### Getting Started

1. **Access the plugin** via Admin → iCal Manager
2. **Review the listings overview** to see all properties with iCal imports
3. **Click "Manage"** on any listing for detailed management
4. **Use bulk operations** for efficient management of multiple listings

### Managing Individual Listings

From the listings overview:
- **Click listing title** to go to detailed view
- **Use "Manage"** button for iCal-specific management
- **Use "Force Update"** to immediately refresh imports
- **Use "Preview"** to see upcoming events

### Bulk Operations

Select multiple listings and choose from:
- **Force Update All** - Refresh all selected imports
- **Preview All** - Generate previews for all imports
- **Export Data** - Download CSV of import data
- **Health Check** - Identify broken or problematic imports

### Settings Configuration

Navigate to **iCal Manager → Settings** to configure:

#### General Settings
- **Batch Size** (1-100): Number of listings per cron job
- **Cron Frequency**: How often to auto-update imports

#### Performance Settings
- **Max Execution Time** (10-300s): Timeout for operations
- **Memory Limit Check** (10-500MB): Memory usage monitoring
- **Rate Limit Delay** (100-5000ms): Delay between requests

#### Security Settings
- **Allowed Domains**: Whitelist for iCal URL sources
- **Request Timeout** (5-120s): HTTP request timeout

#### Logging Settings
- **Log Retention** (1-365 days): How long to keep history
- **Detailed Logging**: Enable debug-level logging

## 🔧 Technical Details

### Database Tables

The plugin creates one additional table:
- `wp_listeo_ical_import_history` - Tracks all import operations

### Performance Optimizations

- **Batched processing** prevents timeouts
- **Memory monitoring** prevents server crashes
- **Rate limiting** prevents API abuse
- **Change detection** avoids unnecessary imports
- **Caching** improves response times

### Security Features

- **Nonce verification** on all AJAX requests
- **Capability checks** for admin access
- **URL validation** and domain whitelisting
- **SSRF protection** against internal requests
- **Input sanitization** throughout

### Error Handling

- **Graceful failure** handling
- **Detailed error logging**
- **User-friendly error messages**
- **Recovery mechanisms** for failed operations

## 🐛 Troubleshooting

### Common Issues

**Plugin won't activate:**
- Ensure Listeo Core is active
- Check PHP version (7.4+ required)
- Verify memory limit (256MB+ recommended)

**Imports not working:**
- Check import history for error messages
- Verify iCal URLs are accessible
- Review allowed domains in settings
- Check server firewall/security settings

**Performance issues:**
- Reduce batch size in settings
- Increase memory limit in wp-config.php
- Enable caching plugin
- Review detailed logs for bottlenecks

**Import history not showing:**
- Check database table was created properly
- Verify user permissions
- Clear any caching plugins

### Debug Mode

Enable detailed logging in settings and check:
- WordPress debug log (`/wp-content/debug.log`)
- Import history table for error messages
- System status in settings sidebar

## 📊 System Requirements

### Minimum Requirements
- WordPress: 5.0+
- PHP: 7.4+
- MySQL: 5.6+
- Memory: 256MB+

### Recommended Requirements
- WordPress: 6.0+
- PHP: 8.0+
- MySQL: 8.0+
- Memory: 512MB+
- Max execution time: 300s+

## 🔄 Changelog

### Version 1.0.0
- Initial release
- Complete admin interface
- Bulk operations support
- Import history and logging
- Advanced settings configuration
- Security enhancements
- Performance optimizations

## 📞 Support

For technical support or feature requests:

1. **Check documentation** first
2. **Review import history** for error details
3. **Enable debug logging** to gather more information
4. **Contact support** with specific error messages and system details

## 📄 License

This plugin is licensed under GPL v2 or later.

## 🔗 Related Documentation

- [Listeo Core Documentation](../listeo-core/)
- [WordPress Plugin Development](https://developer.wordpress.org/plugins/)
- [iCal RFC Specification](https://tools.ietf.org/html/rfc5545)

---

*This plugin was developed to provide enterprise-level management capabilities for Listeo iCal functionality, ensuring reliable, secure, and efficient handling of calendar imports across large-scale implementations.*