<?php
/**
 * Simple Working Listings Table
 */

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('WP_List_Table')) {
    require_once(ABSPATH . 'wp-admin/includes/class-wp-list-table.php');
}

class Listeo_iCal_Admin_Simple_Table extends WP_List_Table {

    public function __construct() {
        parent::__construct(array(
            'singular' => 'listing',
            'plural'   => 'listings',
            'ajax'     => false
        ));
    }

    public function get_columns() {
        return array(
            'cb'              => '<input type="checkbox" />',
            'title'           => 'Title',
            'status'          => 'Status',
            'ical_management' => 'iCal Management',
            'ical_export'     => 'iCal Export'
        );
    }

    public function prepare_items() {
        $this->_column_headers = array($this->get_columns(), array(), array());

        $posts = get_posts(array(
            'post_type' => 'listing',
            'numberposts' => 20,
            'post_status' => 'any'
        ));

        $this->items = $posts;

        $this->set_pagination_args(array(
            'total_items' => count($posts),
            'per_page'    => 20,
            'total_pages' => 1
        ));
    }

    public function column_cb($item) {
        return sprintf('<input type="checkbox" name="listing[]" value="%s" />', $item->ID);
    }

    public function column_title($item) {
        // make tittle link to view listing
        return '<strong><a href="' . esc_url(get_permalink($item->ID)) . '">' . esc_html($item->post_title) . '</a></strong>';
    }

    public function column_id($item) {
        return $item->ID;
    }

    public function column_status($item) {
        return $item->post_status;
    }

    public function column_ical_management($item) {
        $ical_imports = get_post_meta($item->ID, 'listeo_ical_imports', true);
        $ical_imports = is_array($ical_imports) ? $ical_imports : array();
        $booking_enabled = get_post_meta($item->ID, '_booking_status', true);

        $output = '<div class="ical-management-wrapper" data-listing-id="' . esc_attr($item->ID) . '">';

        // Booking status indicator
        if ($booking_enabled !== 'on') {
            $output .= '<div class="booking-disabled-notice">';
            $output .= '<span class="dashicons dashicons-warning"></span>';
            $output .= '<p><strong>Booking is disabled</strong><br><small>Enable booking to use iCal imports</small></p>';
            $output .= '</div>';
            $output .= '</div>';
            return $output;
        }

        // Show existing imports in a nicer format
        if (!empty($ical_imports)) {
            $output .= '<div class="existing-imports">';
            $output .= '<div class="imports-header">';
            $output .= '<span class="dashicons dashicons-calendar-alt"></span>';
            $output .= '<strong>' . sprintf('%d Active Import(s)', count($ical_imports)) . '</strong>';
            $output .= '</div>';

            foreach ($ical_imports as $index => $import) {
                if (!isset($import['name']) || !isset($import['url'])) continue;

                $output .= '<div class="import-item-enhanced" data-import-index="' . esc_attr($index) . '">';
                $output .= '<div class="import-header">';
                $output .= '<span class="import-name">' . esc_html($import['name']) . '</span>';
                $output .= '<div class="import-actions-inline">';
                $output .= '<button type="button" class="button-link ical-force-update" data-listing-id="' . esc_attr($item->ID) . '" data-import-index="' . esc_attr($index) . '" title="Sync now"><span class="dashicons dashicons-update"></span></button>';
                $output .= '<button type="button" class="button-link ical-preview" data-listing-id="' . esc_attr($item->ID) . '" data-import-index="' . esc_attr($index) . '" title="Preview events"><span class="dashicons dashicons-visibility"></span></button>';
                $output .= '<button type="button" class="button-link ical-remove" data-listing-id="' . esc_attr($item->ID) . '" data-import-index="' . esc_attr($index) . '" title="Remove import"><span class="dashicons dashicons-trash"></span></button>';
                $output .= '</div>';
                $output .= '</div>';
                $output .= '<div class="import-url">';
                $output .= '<a href="' . esc_url($import['url']) . '" target="_blank" title="' . esc_attr($import['url']) . '">';
                $output .= esc_html(strlen($import['url']) > 45 ? substr($import['url'], 0, 45) . '...' : $import['url']);
                $output .= '</a>';
                $output .= '</div>';
                $output .= '<div id="ical-status-' . esc_attr($item->ID) . '-' . esc_attr($index) . '" class="ical-import-status"></div>';
                $output .= '</div>';
            }
            $output .= '</div>';
        }

        // Add new import form with better design
        $output .= '<div class="add-import-form-enhanced" style="' . (!empty($ical_imports) ? 'margin-top: 15px; border-top: 1px solid #ddd; padding-top: 15px;' : '') . '">';

        // Show status if no imports exist
        if (empty($ical_imports)) {
            $output .= '<div class="no-imports-notice">';
            $output .= '<span class="dashicons dashicons-calendar-alt"></span>';
            $output .= '<small style="color: #666; margin-left: 5px;">No iCal imports configured</small>';
            $output .= '</div>';
        }

        $output .= '<div class="form-header">';
        $output .= '<span class="dashicons dashicons-plus-alt"></span>';
        $output .= '<strong>Add iCal Import</strong>';
        $output .= '</div>';
        $output .= '<div class="inline-import-form-enhanced" data-listing-id="' . esc_attr($item->ID) . '" data-form-type="ical-import">';
        $output .= '<div class="form-row">';
        $output .= '<label for="import_name_' . $item->ID . '">Name:</label>';
        $output .= '<input type="text" id="import_name_' . $item->ID . '" placeholder="e.g. Airbnb Calendar" name="import_name" required>';
        $output .= '</div>';
        $output .= '<div class="form-row">';
        $output .= '<label for="import_url_' . $item->ID . '">iCal URL:</label>';
        $output .= '<input type="url" id="import_url_' . $item->ID . '" placeholder="https://..." name="import_url" required>';
        $output .= '</div>';
        $output .= '<div class="form-row checkbox-row">';
        $output .= '<label>';
        $output .= '<input type="checkbox" name="force_update">';
        $output .= 'Override existing bookings';
        $output .= '<small class="help-text">Check this if you want to overwrite conflicting dates</small>';
        $output .= '</label>';
        $output .= '</div>';
        $output .= '<div class="form-actions">';
        $output .= '<button type="button" class="button button-primary button-small ical-add-import-btn" data-listing-id="' . esc_attr($item->ID) . '">';
        $output .= '<span class="dashicons dashicons-plus"></span> Add Import';
        $output .= '</button>';
        $output .= '</div>';
        $output .= '</div>';
        $output .= '</div>';

        $output .= '</div>';
        return $output;
    }

    public function column_ical_export($item) {
        $booking_enabled = get_post_meta($item->ID, '_booking_status', true);

        if ($booking_enabled !== 'on') {
            return '<div class="export-disabled">'
                 . '<span class="dashicons dashicons-warning"></span>'
                 . '<span class="status-inactive">Booking disabled</span>'
                 . '</div>';
        }

        // Generate export URL (check if function exists, otherwise create basic URL)
        if (function_exists('listeo_ical_export_url')) {
            $export_url = listeo_ical_export_url($item->ID);
        } else {
            $export_url = home_url('/listeo-ical-export/' . $item->ID . '/');
        }

        $output = '<div class="ical-export-wrapper-enhanced">';
        $output .= '<div class="export-header">';
        $output .= '<span class="dashicons dashicons-download"></span>';
        $output .= '<strong>Export Calendar</strong>';
        $output .= '</div>';
        $output .= '<div class="export-content">';
        $output .= '<div class="export-url-wrapper">';
        $output .= '<input type="text" value="' . esc_attr($export_url) . '" class="export-url-input" readonly>';
        $output .= '<button type="button" class="button button-secondary button-small copy-export-url" data-url="' . esc_attr($export_url) . '" data-listing-id="' . esc_attr($item->ID) . '">';
        $output .= '<span class="dashicons dashicons-clipboard"></span> Copy';
        $output .= '</button>';
        $output .= '</div>';
        $output .= '<small class="export-help">Share this URL with external calendar apps (Google Calendar, Outlook, etc.)</small>';
        $output .= '</div>';
        $output .= '</div>';

        return $output;
    }
}