jQuery(function($) {

	"use strict";

	// Clicked Zoom Functionality
	$('.woocommerce .product_content_wrapper .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image').on( 'click', function(e) {
		if( $(window).width() >= 1024 ) {
			e.preventDefault();

			$('.woocommerce .product_content_wrapper .product_wrapper .flex-viewport').css( 'height', 'auto' );

			if( !$('.woocommerce .product_content_wrapper .product_wrapper').hasClass('zoom-in') ) {
				$('.woocommerce .product_content_wrapper .product_wrapper').removeClass('zoom-out');
				$('.woocommerce .product_content_wrapper .product_wrapper').removeClass('animated');
				$('.woocommerce .product_content_wrapper .product_wrapper').addClass('zoom-in');
			} else {
				$('.woocommerce .product_content_wrapper .product_wrapper').removeClass('zoom-in');
				$('.woocommerce .product_content_wrapper .product_wrapper').removeClass('animated');
				$('.woocommerce .product_content_wrapper .product_wrapper').addClass('zoom-out');
			}

			setTimeout( function() {
				$('.flex-viewport').resize();
				$('.woocommerce .product_content_wrapper .product_wrapper .flex-viewport').css( 'height', 'auto' );
			}, 600);

			setTimeout( function() {
				$('.woocommerce .product_content_wrapper .product_wrapper').addClass('animated');
				var flex_height = $(document).find('.flex-active-slide img').outerHeight();
				$('.woocommerce .product_content_wrapper .product_wrapper .flex-viewport').css( 'height', flex_height );
			}, 700);
		}
	});

	// Set Temp Image used for Clicked Zoom
	$('.woocommerce .product_content_wrapper .woocommerce-product-gallery .flex-control-thumbs li img').on( 'click', function() {
		if( $(window).width() >= 1024 ) {
			setTimeout( function() {
				var image = $(document).find('.flex-active-slide img').attr( 'src' );
				$('.woocommerce .product_content_wrapper .product_wrapper .product-image-temp img').attr('srcset', '').attr( 'src', image );
			}, 100);
		}
	});

	// Default Gallery - Scroll thumbnails
	$(document).on('click touchend', '.woocommerce .product_content_wrapper .product_wrapper ol.flex-control-thumbs li img', function() {
		if( $(window).width() >= 1280 ) {
			var product_thumbnails 				= $('ol.flex-control-thumbs');
			var product_thumbnails_cells 		= product_thumbnails.find('li');
			var product_thumbnails_height 		= product_thumbnails.height();
			var product_thumbnails_cells_height	= product_thumbnails_cells.length ? product_thumbnails_cells.outerHeight() : 0;
			var product_images					= $('.woocommerce-product-gallery__wrapper');
			var index 							= $('.woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image.flex-active-slide').index();

			var scrollY = (index * product_thumbnails_cells_height) - ( (product_thumbnails_height - product_thumbnails_cells_height) / 2) - 10;

			product_thumbnails.animate({
				scrollTop: scrollY
			}, 300);
		}
	});

	// Default Gallery - Mobile scroll thumbnails
	$(document).on('click touchend', '.woocommerce .product_content_wrapper .product_wrapper ol.flex-control-thumbs li img', function() {
		if( $(window).width() < 1280 ) {
			var product_thumbnails 				= $('ol.flex-control-thumbs');
			var product_thumbnails_cells 		= product_thumbnails.find('li');
			var product_thumbnails_width 		= product_thumbnails.width();
			var product_thumbnails_cells_width	= product_thumbnails_cells.length ? product_thumbnails_cells.outerWidth() : 0;
			var product_images					= $('.woocommerce-product-gallery__wrapper');
			var index 							= $('.woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image.flex-active-slide').index();

			var scrollX = (index * product_thumbnails_cells_width) - ( (product_thumbnails_width - product_thumbnails_cells_width) / 2);

			product_thumbnails.animate({
				scrollLeft: scrollX
			}, 300);
		}
	});

	$(".product-image-temp").detach().prependTo('.woocommerce-product-gallery');
});
