jQuery(function($) {

	"use strict";

	window.search_wrapper_open = false;

	function search_widgets_equal_height() {

		$('.search-widget-area').find('li.widget').css('min-height', $('.search-widget-area').height());

	};

	window.search_wrapper_fn = function() {

		if ( !window.search_wrapper_open ) {
			$('body').addClass('noscroll');
			if (Foundation.utils.is_large_up() && $(document).scrollTop() <= 0) $('body.header-transparent.header-sticky').addClass("header-sticky-scroll no-transparency-lock");
			$(".search_wrapper").slideDown(200);
			$('.site-content-overlay').addClass("visible");
			search_widgets_equal_height();
			setTimeout(function(){
				$('.search_wrapper').find('.search-field').trigger('focus');
			}, 500);
			window.search_wrapper_open = true;

		} else {
			$('body').removeClass('noscroll');
			if (Foundation.utils.is_large_up() && $(document).scrollTop() <= 0) $('body.header-transparent.header-sticky').removeClass("header-sticky-scroll no-transparency-lock");
			$(".search_wrapper").slideUp(200);
			$('.site-content-overlay').removeClass("visible");
			$('.search_wrapper').find('.search-field').trigger('blur');
			window.search_wrapper_open = false;

		}

	}

	$(".search-button").on("click", function() {

		if( !window.search_wrapper_open ) {
			window.close_all_header_dropdowns();

			setTimeout(function() {
				window.search_wrapper_fn();
			}, 200);
		} else {
			window.search_wrapper_fn();
		}
	});

	$(window).on( 'resize', function() {
		search_widgets_equal_height();
	});

	// search widgets dropdown apply scrollbar when longer than the screen
	if( $('.site-header .search_wrapper').length ) {
		var menu_dropdown_offset = 0;
		menu_dropdown_offset += $('.site-header').length ? $('.site-header').outerHeight() : 0;
		menu_dropdown_offset += $('#wpadminbar').length ? $('#wpadminbar').outerHeight() : 0;
		var menu_height = $(window).height() - menu_dropdown_offset;
		$('.site-header .search_wrapper').css( {'max-height': menu_height - 125, 'overflow-y': 'auto' });
	}

	// predictive search
	if( getbowtied_scripts_vars.predictive_search ) {

        var el = $('.getbowtied-ajaxsearchform-container form.woocommerce-product-search .search-field'),
            search_button = $('.getbowtied-ajaxsearchform-container form.woocommerce-product-search button[type="submit"]'),
            min_chars = el.data('min-chars');

        search_button.on('click', function(){
            var form = $(this).closest('form');
            if( form.find('.search-field').val()==''){
                return false;
            }
            return true;
        });

        if( el.length == 0 ) el = $('.getbowtied-ajaxsearchform-container form.woocommerce-product-search .search-field');

        el.each(function () {
            var $t = $(this),
                append_to = ( typeof  $t.data('append-to') == 'undefined') ? $t.closest('.getbowtied-ajaxsearchform-container') : $t.data('append-to');

            $t.autocomplete({
                minChars        : min_chars,
                appendTo        : append_to,
                triggerSelectOnValidInput: false,
                deferRequestBy  : 100,
                serviceUrl      : getbowtied_scripts_vars.ajax_url + '?action=getbowtied_ajax_search_products',
                onSearchStart   : function () {
                    $t.addClass('loading');
                },
                onSelect        : function (suggestion) {
                    if (suggestion.id != -1) {
                        window.location.href = suggestion.url;
                    }
                }  ,
                onSearchComplete: function (query, suggestions) {
                    $t.removeClass('loading');

                    if ( suggestions.length == 0 ) {
                        $('.search-suggestions-title').text(getbowtied_scripts_vars.search_no_suggestions_text).addClass('no-suggestions').show();
                    } else {
                        $('.search-suggestions-title').text(getbowtied_scripts_vars.search_suggestions_text).removeClass('no-suggestions');
                    }
                }
            });
        });

        $('<h4 class="search-suggestions-title"></h4>').insertBefore( ".autocomplete-suggestions" );
    }

})
