<?php
/**
 * Customizer Theme Options
 */

class Merchandiser_Options {

    /**
	 * Cache each request to prevent duplicate queries
	 *
	 * @var array
	 */
	protected static $cached = [];

	/**
	 *  We don't need a constructor
	 */
	private function __construct() {}

	/**
	 * Default values for theme options
	 *
	 * @return array
	 */
	private static function theme_defaults() {

		return [

        	// Header
			'header_layout'								=> 'header_2',
			'header_navigation_style'					=> 'slices',
			'header_navigation_alignment'				=> 'align_left',
			'header_height'								=> 75,
			'header_background_color'					=> '#23282d',
			'header_font_size'							=> 13,
			'header_font_color'							=> '#ffffff',
			'header_dropdown_font_size'					=> 13,
			'header_logo'								=> '',
			'header_alt_logo'							=> '',
			'header_alt_logo_height'					=> 55,
			'header_wishlist'							=> true,
			'header_wishlist_icon'						=> '',
			'header_search'								=> true,
			'header_search_icon'						=> '',
			'header_cart'								=> true,
			'header_cart_icon'							=> '',
			'header_user_account'						=> true,
			'header_user_account_icon'					=> '',
			'header_sticky'								=> true,
			'header_transparent'						=> false,
			'header_transparent_sticky_default_logo' 	=> false,
			'header_transparent_scheme'					=> 'dark',
			'header_transparent_light_color' 			=> '#ffffff',
			'header_transparent_light_logo' 			=> '',
			'header_transparent_dark_color'				=> '#000000',
			'header_transparent_dark_logo'				=> '',

			// Styling
			'accent_color'						=> '#ffc741',
			'bg_color'							=> '#ffffff',
			'page_title_bg_color'				=> '#ffc741',
			'page_title_text_color'				=> '#ffffff',

			// Fonts
			'font_size'							=> 18,
			'primary_color'						=> '#000000',
			'fonts_font_face_display'			=> 'swap',
			'default_theme_fonts'				=> 'default_fonts',
			'default_fonts_variant'				=> '2',
			'new_main_font'						=> 'Roboto',
			'new_secondary_font'				=> 'Roboto',

			// Blog
			'blog_layout'						=> 'blog_layout_default',
			'blog_pagination'					=> 'infinite_scroll',
			'single_post_layout'				=> 'single_post_2',

			// Shop
			'catalog_mode'						=> false,
			'shop_layout_style'					=> 'regular',
			'shop_sidebar'						=> true,
			'products_spacing'					=> 0,
			'shop_pagination'					=> 'infinite_scroll',
			'shop_predictive_search'			=> true,
			'shop_product_details'				=> true,
			'shop_quick_view'					=> true,
			'shop_second_image'					=> true,
			'custom_sale_label'					=> esc_html__( 'Sale!', 'getbowtied' ),
			'custom_sale_color'					=> '#ffc741',
			'custom_out_of_stock_label'			=> esc_html__( 'Out of stock', 'getbowtied' ),
			'shop_hover_shadow'					=> true,
			'open_minicart'						=> true,

			// Product Category
			'category_height'					=> 150,
			'category_transparency'				=> 'inherit',

			// Product Page
			'product_image_gallery'				=> 'half_page',
			'product_image_zoom'				=> true,
			'related_products'					=> true,

			// Footer
			'footer_sticky'						=> false,
			'back_to_top'						=> true,
			'footer_background_color'			=> '#000000',
			'footer_font_color'					=> '#ffffff',
			'footer_links_color'				=> '#ffffff',
			'footer_copyright'					=> esc_html__( 'Powered by ', 'getbowtied' ) . '<a href="'.MERCHANDISER_THEME_WEBSITE.'" title="eCommerce WordPress Theme for Woocommerce">'.esc_html__( 'Merchandiser', 'getbowtied' ).'</a>.',
		];
	}

	/**
	 * Writes the options inline styles
	 *
	 * @return void
	 */
	public static function get_options_css() {
		$accent_color_rgb   			= 'rgb('.Merchandiser::convert_hex_to_rgb(self::getOption( 'accent_color', '#ffc741' )).')';
		$accent_color_light_rgb   		= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'accent_color', '#ffc741' )).',0.25)';
		$primary_color_rgb   			= 'rgb('.Merchandiser::convert_hex_to_rgb(self::getOption( 'primary_color', '#000000' )).')';
		$primary_color_medium_rgb   	= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'primary_color', '#000000' )).', 0.5)';
		$primary_color_light 			= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'primary_color', '#000000' )).', 0.15)';
		$primary_color_ultra_light 		= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'primary_color', '#000000' )).', 0.05)';
		$page_title_color_rgb 	  		= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'page_title_text_color', '#ffffff' )).')';
		$footer_color_rgb   			= 'rgb('.Merchandiser::convert_hex_to_rgb(self::getOption( 'footer_font_color', '#ffffff' )).')';
		$footer_color_medium_rgb    	= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'footer_font_color', '#ffffff' )).', 0.5)';
		$footer_color_ultra_light 		= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'footer_font_color', '#ffffff' )).', 0.05)';
		$header_font_color_light 		= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'header_font_color', '#ffffff' )).', 0.1)';
		$header_font_color_ultra_light 	= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'header_font_color', '#ffffff' )).', 0.05)';
		$header_bg_color_dark 			= 'rgba('.Merchandiser::convert_hex_to_rgb(self::getOption( 'header_background_color', '#23282d' )).', 0.85)';

		$star_empty_icon = 'M 13.03125 1.15625 C 12.957031 1.160156 12.882813 1.167969 12.8125 1.1875 C 12.496094 1.25 12.230469 1.457031 12.09375 1.75 L 8.84375 8.375 L 1.46875 9.46875 C 1.105469 9.535156 0.804688 9.796875 0.695313 10.152344 C 0.582031 10.507813 0.675781 10.894531 0.9375 11.15625 L 6.21875 16.34375 L 5 23.65625 C 4.9375 24.027344 5.085938 24.40625 5.390625 24.632813 C 5.695313 24.855469 6.101563 24.890625 6.4375 24.71875 L 13 21.25 L 19.5625 24.71875 C 19.898438 24.890625 20.304688 24.855469 20.609375 24.632813 C 20.914063 24.40625 21.0625 24.027344 21 23.65625 L 19.78125 16.34375 L 25.0625 11.15625 C 25.324219 10.894531 25.417969 10.507813 25.304688 10.152344 C 25.195313 9.796875 24.894531 9.535156 24.53125 9.46875 L 17.15625 8.375 L 13.90625 1.75 C 13.75 1.402344 13.414063 1.171875 13.03125 1.15625 Z M 13 4.46875 L 15.625 9.75 C 15.773438 10.039063 16.054688 10.238281 16.375 10.28125 L 22.21875 11.15625 L 18 15.28125 C 17.757813 15.503906 17.640625 15.832031 17.6875 16.15625 L 18.6875 22 L 13.46875 19.25 C 13.175781 19.09375 12.824219 19.09375 12.53125 19.25 L 7.3125 22 L 8.3125 16.15625 C 8.359375 15.832031 8.242188 15.503906 8 15.28125 L 3.78125 11.15625 L 9.625 10.28125 C 9.945313 10.238281 10.226563 10.039063 10.375 9.75 Z ';

		$custom_header_height_max = max( Merchandiser_Options::getOption( 'header_height', 75 ), Merchandiser_Options::getOption( 'header_logo_height', 75 ), 3*Merchandiser_Options::getOption( 'header_font_size', 14 ) );

		$options = '
			:root {
				--global--accent-color: 	 				' . self::getOption( 'accent_color', '#ffc741' ) . ';
				--global--bg-color: 	 					' . self::getOption( 'bg_color', '#ffffff' ) . ';
				--global--text-color: 	 					' . self::getOption( 'primary_color', '#000000' ) . ';

				--global--text-color-medium:				' . $primary_color_medium_rgb . ';
				--global--text-color-light:					' . $primary_color_light . ';
				--global--text-color-ultra-light:			' . $primary_color_ultra_light . ';
				--global--text-color-rgb:					' . $primary_color_rgb . ';
				--global--accent-color-rgb:					' . $accent_color_rgb . ';

				--global--header-font-size: 				' . self::getOption( 'header_font_size', 13 ) . 'px;
				--global--header-dropdown-font-size: 		' . self::getOption( 'header_dropdown_font_size', 13 ) . 'px;
				--global--header-bg-color: 					' . self::getOption( 'header_background_color', '#23282d' ) . ';
				--global--header-bg-dark-color:				' . $header_bg_color_dark . ';
				--global--header-font-light-color:			' . $header_font_color_light . ';
				--global--header-font-ultra-light-color:	' . $header_font_color_ultra_light . ';
				--global--header-font-color:				' . self::getOption( 'header_font_color', '#ffffff' ) . ';
				--global--header-max-height:     			' . $custom_header_height_max . 'px;
				--global--header-logo-height: 				' . self::getOption( 'header_logo_height', 75 ) . 'px;
				--global--header-alt-logo-height: 			' . self::getOption( 'header_alt_logo_height', 55 ) . 'px;

				--global--header-transparent-light-color:	' . self::getOption( 'header_transparent_light_color', '#ffffff' ) . ';
				--global--header-transparent-dark-color:	' . self::getOption( 'header_transparent_dark_color', '#000000' ) . ';

				--global--footer-bg-color: 					' . self::getOption( 'footer_background_color', '#000000' ) . ';
				--global--footer-font-color:				' . self::getOption( 'footer_font_color', '#ffffff' ) . ';
				--global--footer-font-color-medium:			' . $footer_color_medium_rgb . ';
				--global--footer-font-color-ultra-light:	' . $footer_color_ultra_light . ';
				--global--footer-links-color:				' . self::getOption( 'footer_links_color', '#ffffff' ) . ';

				--global--page-title-bg-color: 				' . self::getOption( 'page_title_bg_color', '#ffc741' ) . ';
				--global--page-title-font-color:			' . self::getOption( 'page_title_text_color', '#ffffff' ) . ';

				--global--category-height: 					' . self::getOption( 'category_height', 70 ) . 'px;

				--global--sale-badge-color:					' . self::getOption( 'custom_sale_color', '#ffc741' ) . ';

				--global--font-primary: 	 				' . Merchandiser_Fonts::get_main_font() . ';
				--global--font-secondary: 	 				' . Merchandiser_Fonts::get_secondary_font() . ';

				--global--font-face-display:				' . self::getOption( 'fonts_font_face_display', 'swap' ) . ';
				--global--font-size:						' . self::getOption( 'font_size', 18 ) . 'px;

				--global--products-spacing:     			' . self::getOption( 'products_spacing', 0 ) . 'px;
			}

			.woocommerce .star-rating,
			.wc-block-review-list-item__rating__stars,
			.woocommerce p.stars a,
			.woocommerce p.stars.selected a.active~a {
				background-image: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'18\' height=\'18\' viewBox=\'0 0 24 24\' fill=\''.$accent_color_rgb.'\'><path d=\'M12,6.019l1.618,3.279l0.465,0.943l1.041,0.151l3.618,0.526l-2.618,2.552l-0.753,0.734l0.178,1.036l0.618,3.604 l-3.236-1.701L12,16.653l-0.931,0.489l-3.236,1.701l0.618-3.604l0.178-1.036L7.876,13.47l-2.618-2.552l3.618-0.526l1.041-0.151 l0.465-0.943L12,6.019 M12,1.5L8.588,8.413L0.96,9.521l5.52,5.381L5.177,22.5L12,18.913l6.823,3.587l-1.303-7.598l5.52-5.381 l-7.629-1.109L12,1.5L12,1.5z\'></path></svg>");
			}

			.woocommerce .star-rating span,
			.wc-block-review-list-item__rating__stars span,
			.woocommerce p.stars a:hover,
			.woocommerce p.stars.selected a:not(.active):hover,
			.woocommerce p.stars.selected a {
				background-image: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'18\' height=\'18\' viewBox=\'0 0 24 24\' fill=\''.$accent_color_rgb.'\'><path d=\'M 12 1.5 L 8.5878906 8.4121094 L 0.9609375 9.5214844 L 6.4804688 14.902344 L 5.1777344 22.5 L 12 18.912109 L 18.822266 22.5 L 17.519531 14.902344 L 23.039062 9.5214844 L 15.412109 8.4121094 L 12 1.5 z\'></path></svg>");
			}

			select,
			.select2-container--default .select2-selection--single .select2-selection__arrow b {
				background-image: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'14\' height=\'14\' viewBox=\'0 0 16 11\' fill=\''.$primary_color_rgb.'\'><path d=\'M8.59758829,10.705005 L15.8475883,1.20500499 C16.2242892,0.711396858 15.8723037,0 15.2513749,0 L0.751374855,0 C0.130446045,0 -0.221539522,0.711396858 0.155161421,1.20500499 L7.40516142,10.705005 C7.70533178,11.0983317 8.29741793,11.0983317 8.59758829,10.705005 Z M2.26719736,1.5 L13.7355523,1.5 L8.00137486,9.01374982 L2.26719736,1.5 Z\'></path></svg>");
			}

			.footer-widget-wrapper select,
			.footer-widget-wrapper .select2-container--default .select2-selection--single .select2-selection__arrow b {
				background-image: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'14\' height=\'14\' viewBox=\'0 0 16 11\' fill=\''.$footer_color_rgb.'\'><path d=\'M8.59758829,10.705005 L15.8475883,1.20500499 C16.2242892,0.711396858 15.8723037,0 15.2513749,0 L0.751374855,0 C0.130446045,0 -0.221539522,0.711396858 0.155161421,1.20500499 L7.40516142,10.705005 C7.70533178,11.0983317 8.29741793,11.0983317 8.59758829,10.705005 Z M2.26719736,1.5 L13.7355523,1.5 L8.00137486,9.01374982 L2.26719736,1.5 Z\'></path></svg>");
			}

			.woocommerce .shop-page-header .shop-page-title-bar ul.shop-tools>li .shop-tools-button .change_layout .nl-field .nl-field-toggle {
				background-image: url("data:image/svg+xml;utf8,<svg xmlns=\'http://www.w3.org/2000/svg\' width=\'20\' height=\'20\' viewBox=\'0 0 24 24\' fill=\''.$page_title_color_rgb.'\'><path d=\'M 1 4 L 1 8 L 7 8 L 7 4 L 1 4 z M 9 4 L 9 8 L 15 8 L 15 4 L 9 4 z M 17 4 L 17 8 L 23 8 L 23 4 L 17 4 z M 1 10 L 1 14 L 7 14 L 7 10 L 1 10 z M 9 10 L 9 14 L 15 14 L 15 10 L 9 10 z M 17 10 L 17 14 L 23 14 L 23 10 L 17 10 z M 1 16 L 1 20 L 7 20 L 7 16 L 1 16 z M 9 16 L 9 20 L 15 20 L 15 16 L 9 16 z M 17 16 L 17 20 L 23 20 L 23 16 L 17 16 z\'></path></svg>");
			}
		';

		return self::compress_styles($options);
	}

	/**
	 * Compress custom styles
	 */
	public static function compress_styles( $minify ) {
		$minify = preg_replace('/\/\*((?!\*\/).)*\*\//','',$minify); // negative look ahead
		$minify = preg_replace('/\s{2,}/',' ',$minify);
		$minify = preg_replace('/\s*([:;{}])\s*/','$1',$minify);
		$minify = preg_replace('/;}/','}',$minify);

		return $minify;
	}

    /**
	 * Switch case for options that need post processing
	 *
	 * @param  [string] $key   [name of option]
	 * @param  [string] $value [value]
	 *
	 * @return [string]        [processed value]
	 */
	private static function processOption($key, $value) {

		return $value;
	}

    /**
	 * Return the theme option from cache; if it isn't cached fetch it and cache it
	 *
	 * @param  string $option_name
	 * @param  string $default
	 *
	 * @return string
	 */
	public static function getOption( $option_name, $default= '' ) {
 		/* Return cached if possible */
 		if ( array_key_exists($option_name, self::$cached) && empty($default) )
 			return self::$cached[$option_name];
 		/* If no default is given, fetch from theme defaults variable */
 		if (empty($default)) {
 			$default = array_key_exists($option_name, self::theme_defaults())? self::theme_defaults()[$option_name] : '';
 		}

 		$opt= get_theme_mod($option_name, $default);

 		/* Cache the result */
 		self::$cached[$option_name]= $opt;

 		/* Process the variable */
 		if ( $opt !== self::processOption($option_name, $opt) ) {
 			self::$cached[$option_name]= self::processOption($option_name, $opt);
 		}

 		return self::$cached[$option_name];
 	}
}

?>
