<?php if ( post_password_required() ) return; ?>

<div class="comments_section">
    <div id="comments" class="comments-area">
		<div class="row">
			<div class="large-9 small-centered columns">

                <div class="comments-number">
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 100 100">
                        <path d="M50,92c-1.104,0-2-0.896-2-2s0.896-2,2-2c13.533,0,26.143-7.28,32.908-19c6.767-11.72,6.767-26.28,0-38  C76.143,19.28,63.533,12,50,12c-13.533,0-26.143,7.28-32.909,19c-6.766,11.72-6.766,26.28,0,38  c3.444,5.966,1.502,12.072-5.468,17.193c-0.348,0.256-0.491,0.705-0.355,1.117C11.403,87.724,11.785,88,12.218,88H40  c1.104,0,2,0.896,2,2s-0.896,2-2,2H12.218c-2.166,0-4.075-1.383-4.75-3.44c-0.677-2.06,0.042-4.306,1.787-5.589  c7.922-5.821,5.25-10.45,4.373-11.971c-7.479-12.953-7.479-29.047,0-42S35.043,8,50,8c14.958,0,28.895,8.047,36.373,21  s7.479,29.047,0,42S64.958,92,50,92z"/>
                    </svg>
                    <span><?php echo esc_html(get_comments_number()); ?></span>
                </div>

		        <?php if ( have_comments() ) : ?>

		            <h2 class="comments-title">
		                <?php
		                    printf( // WPCS: XSS OK.
		                        esc_html( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'getbowtied' ) ),
		                        number_format_i18n( get_comments_number() ),
		                        '<span>' . get_the_title() . '</span>'
		                    );
		                ?>
		            </h2>

		            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		            <nav id="comment-nav-above" class="comment-navigation" >
		                <h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'getbowtied' ); ?></h1>
		                <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'getbowtied' ) ); ?></div>
		                <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'getbowtied' ) ); ?></div>
		            </nav><!-- #comment-nav-above -->
		            <?php endif; // check for comment navigation ?>

		            <ul class="comment-list">
		            <?php
		                /* Loop through and list the comments. Tell wp_list_comments()
		                 * to use merchandiser_output_comments() to format the comments.
		                 * If you want to override this in a child theme, then you can
		                 * define merchandiser_output_comments() and that will be used instead.
		                 * See merchandiser_output_comments() in includes/template-tags.php for more.
		                 */
		                wp_list_comments( array( 'callback' => 'merchandiser_output_comments' ) );
		            ?>
		            </ul><!-- .comment-list -->

		            <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
		            <nav id="comment-nav-below" class="comment-navigation" >
		                <h1 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'getbowtied' ); ?></h1>
		                <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'getbowtied' ) ); ?></div>
		                <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'getbowtied' ) ); ?></div>
		            </nav><!-- #comment-nav-below -->
		            <?php endif; // check for comment navigation ?>

        		<?php endif; // have_comments() ?>

		        <?php
		            // If comments are closed and there are comments, let's leave a little note, shall we?
		            if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
		        ?>
		            <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'getbowtied' ); ?></p>
		        <?php endif; ?>

		        <div class="comment-respond-form <?php echo ('0' == get_comments_number()) ? 'no-comments' : ''; ?>">
                    <?php comment_form(); ?>
		        </div>

			</div>
		</div>
    </div>
</div>
