<?php
$featured_post_meta = get_post_meta( get_the_ID(), 'post_featured_image_meta_box_check', true );
$post_featured_image_option = !empty($featured_post_meta) ? $featured_post_meta : 'on';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

    <header class="entry-header">
        <?php the_category(); ?>
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>

        <div class="entry-meta">
            <span class="single-author">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                    <path d="M 12 3 C 9.8027056 3 8 4.8027056 8 7 C 8 9.1972944 9.8027056 11 12 11 C 14.197294 11 16 9.1972944 16 7 C 16 4.8027056 14.197294 3 12 3 z M 12 5 C 13.116414 5 14 5.8835859 14 7 C 14 8.1164141 13.116414 9 12 9 C 10.883586 9 10 8.1164141 10 7 C 10 5.8835859 10.883586 5 12 5 z M 12 14 C 10.255047 14 8.1871638 14.409783 6.4492188 15.095703 C 5.5802462 15.438663 4.7946961 15.84605 4.1660156 16.369141 C 3.5373351 16.892231 3 17.599384 3 18.5 L 3 21 L 21 21 L 21 20 L 21 18.5 C 21 17.599384 20.462665 16.892231 19.833984 16.369141 C 19.205304 15.84605 18.419754 15.438663 17.550781 15.095703 C 15.812836 14.409783 13.744953 14 12 14 z M 12 16 C 13.414047 16 15.346055 16.373999 16.818359 16.955078 C 17.554512 17.245618 18.176961 17.591965 18.554688 17.90625 C 18.932412 18.220535 19 18.434616 19 18.5 L 19 19 L 5 19 L 5 18.5 C 5 18.434616 5.0675867 18.220535 5.4453125 17.90625 C 5.8230383 17.591965 6.4454882 17.245618 7.1816406 16.955078 C 8.6539455 16.373999 10.585953 16 12 16 z"/>
                </svg>
                <?php the_author(); ?>
            </span>

            <span class="single-date">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                    <path d="M 6 1 L 6 3 L 5 3 C 3.9 3 3 3.9 3 5 L 3 19 C 3 20.1 3.9 21 5 21 L 19 21 C 20.1 21 21 20.1 21 19 L 21 5 C 21 3.9 20.1 3 19 3 L 18 3 L 18 1 L 16 1 L 16 3 L 8 3 L 8 1 L 6 1 z M 5 5 L 6 5 L 8 5 L 16 5 L 18 5 L 19 5 L 19 7 L 5 7 L 5 5 z M 5 9 L 19 9 L 19 19 L 5 19 L 5 9 z"/>
                </svg>
                <?php the_date(); ?>
            </span>

            <span class="single-comments">
                <a href="<?php comments_link(); ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                        <path d="M 12 2 C 6.5486138 2 2 5.9740326 2 11 C 2 16.025967 6.5486138 20 12 20 C 12.346168 20 12.665158 19.93053 13 19.898438 L 13 23.09375 L 14.541016 22.105469 C 16.703198 20.717704 21.385038 17.115414 21.943359 11.945312 C 21.978757 11.637749 22 11.322745 22 11 C 22 5.9740326 17.451386 2 12 2 z M 12 4 C 16.490614 4 20 7.1899674 20 11 C 20 11.240597 19.985091 11.480626 19.957031 11.722656 L 19.957031 11.726562 L 19.955078 11.730469 C 19.609498 14.93103 17.047504 17.44485 15 19.083984 L 15 17.572266 L 13.802734 17.814453 C 13.217083 17.932675 12.615326 18 12 18 C 7.5093862 18 4 14.810033 4 11 C 4 7.1899674 7.5093862 4 12 4 z M 7 10 L 7 12 L 9 12 L 9 10 L 7 10 z M 11 10 L 11 12 L 13 12 L 13 10 L 11 10 z M 15 10 L 15 12 L 17 12 L 17 10 L 15 10 z"/>
                    </svg>
                    <?php comments_number(); ?>
                </a>
            </span>
        </div>
    </header>

    <?php if ( ('on' === $post_featured_image_option) && ('single_post_2' === Merchandiser_Options::getOption( 'single_post_layout', 'single_post_2' )) ): ?>
        <div class="featured-image alignwide">
            <?php the_post_thumbnail( 'full' ); ?>
        </div>
    <?php endif; ?>

    <div class="entry-content">
        <?php the_content(); ?>
        <?php
        wp_link_pages( array(
            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'getbowtied' ),
            'after'  => '</div>',
        ) );
        ?>
    </div>

    <footer class="entry-footer">
        <?php the_tags( '<div class="tags-links">', ', ', '</div>' ); ?>
    </footer>

</article>
