<?php

// Body Classes
require_once( get_template_directory() . '/functions/function-body-classes.php' );

// Theme Setup
require_once( get_template_directory() . '/class/class-merchandiser.php' );
require_once( get_template_directory() . '/class/class-merchandiser-fonts.php' );
require_once( get_template_directory() . '/class/class-merchandiser-options.php' );
require_once( get_template_directory() . '/functions/function-theme-setup.php' );

// Template Tags
require_once( get_template_directory() . '/includes/template-tags.php' );

// Enqueue Styles & Scripts
require_once( get_template_directory() . '/functions/function-enqueue-styles.php' );
require_once( get_template_directory() . '/functions/function-enqueue-scripts.php' );

// Customiser
require_once( get_template_directory() . '/includes/customiser/config.php' );

include_once( get_template_directory() . '/includes/customiser/sections/header/header-styles.php' );
include_once( get_template_directory() . '/includes/customiser/sections/header/header-transparency.php' );
include_once( get_template_directory() . '/includes/customiser/sections/header/header-elements.php' );
include_once( get_template_directory() . '/includes/customiser/sections/header/header-logo.php' );
include_once( get_template_directory() . '/includes/customiser/sections/header/header-sticky.php' );

include_once( get_template_directory() . '/includes/customiser/sections/section-footer.php' );

include_once( get_template_directory() . '/includes/customiser/sections/section-colors.php' );

include_once( get_template_directory() . '/includes/customiser/sections/section-blog.php' );

include_once( get_template_directory() . '/includes/customiser/sections/section-fonts.php' );

// WP
require_once( get_template_directory() . '/functions/function-wordpress-filters.php' );

// WC
if ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE ) {
	include_once( get_template_directory() . '/functions/function-woocommerce-actions.php' );
	include_once( get_template_directory() . '/functions/function-quickview.php' );

	// Predictive search
	if( Merchandiser_Options::getOption( 'shop_predictive_search', true ) ) {
		require_once( get_template_directory() . '/class/class-merchandiser-predictive-search.php' );
	}

    // Customiser
    include_once( get_template_directory() . '/includes/customiser/sections/section-shop.php' );
    include_once( get_template_directory() . '/includes/customiser/sections/section-product-category.php' );
    include_once( get_template_directory() . '/includes/customiser/sections/section-product.php' );
}

// VC
if ( MERCHANDISER_VISUAL_COMPOSER_IS_ACTIVE ) {
	require_once( get_template_directory() . '/functions/function-wpbakery-config.php' );
}

// Widgets Areas
require_once( get_template_directory() . '/functions/function-widget-areas.php' );

// Meta Boxes
require_once( get_template_directory() . '/includes/metaboxes/page.php' );
require_once( get_template_directory() . '/includes/metaboxes/post.php' );

// Admin

if ( is_admin() || ( defined('WP_CLI') && WP_CLI ) ) {
    require_once( get_template_directory() . '/functions/function-admin-setup.php' );
    include_once( get_template_directory() . '/dashboard/index.php' );
}