<?php

/**
 * Enqueue theme scripts.
 *
 * @return void
 */
function merchandiser_enqueue_theme_scripts() {

	$dependencies = MERCHANDISER_VISUAL_COMPOSER_IS_ACTIVE ? array('jquery', 'wpb_composer_front_js') : array('jquery') ;

	wp_enqueue_script( 'select2' );
	wp_enqueue_script( 'foundation-init-js', 		get_template_directory_uri() . '/assets/js/vendor/foundation.min.js', 	 		 				array('jquery'), '6.4.3',  TRUE );
	wp_enqueue_script( 'hoverintent', 		 		get_template_directory_uri() . '/assets/js/vendor/jquery.hoverIntent.min.js', 	 				array('jquery'), '1.8.0',  TRUE );
	wp_enqueue_script( 'swiper', 					get_template_directory_uri() . '/assets/js/vendor/swiper-bundle.min.js', 						array('jquery'), '6.4.1',  TRUE );

	if( !is_single() ) {
		// incompatible with product gallery
		wp_enqueue_script( 'salvattore', 		 	get_template_directory_uri() . '/assets/js/vendor/salvattore.min.js', 	 		 				array('jquery'), '1.0.9',  TRUE );
	}

	if ( Merchandiser_Options::getOption( 'shop_quick_view', true ) ) {
		wp_enqueue_script('wc-add-to-cart-variation');
	}

	if (is_singular() && comments_open() && get_option( 'thread_comments')) {
		wp_enqueue_script('comment-reply');
	}

	if ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE ) {
		// If WC exists/active load password meter's script for flyout menu's register form.
		if ( ( 'no' === get_option( 'woocommerce_registration_generate_password' ) && ! is_user_logged_in() ) || is_edit_account_page() || is_lost_password_page() ) {
			wp_enqueue_script( 'wc-password-strength-meter' );
		}
	}

	wp_enqueue_script( 'getbowtied-scripts', get_template_directory_uri() . '/assets/js/scripts-dist.js', $dependencies, Merchandiser::get_theme_version(), TRUE );

	// Send variables to js
	$getbowtied_scripts_vars_array = array(
		'ajax_load_more_locale' 	   => esc_html__( 'Load More Items', 'getbowtied' ),
		'ajax_loading_locale' 		   => esc_html__( 'Loading', 'getbowtied' ),
		'ajax_no_more_items_locale'    => esc_html__( 'No more items available.', 'getbowtied' ),
		'mobile_menu_title'			   => esc_html__( 'Menu', 'getbowtied'),
		'blog_pagination_type' 		   => Merchandiser_Options::getOption( 'blog_pagination', 'infinite_scroll' ),
		'blog_layout' 				   => Merchandiser_Options::getOption( 'blog_layout', 'blog_layout_default' ),
		'shop_pagination_type' 		   => Merchandiser_Options::getOption( 'shop_pagination', 'infinite_scroll' ),
		'shop_layout_style' 		   => Merchandiser_Options::getOption( 'shop_layout_style', 'regular' ),
		'shop_products_per_row'		   => get_option('woocommerce_catalog_columns', 4),
		'open_minicart'		 		   => Merchandiser_Options::getOption( 'open_minicart', true ),
		'predictive_search'			   => Merchandiser_Options::getOption( 'shop_predictive_search', true ),
		'search_suggestions_text'	   => esc_html__( 'Search Results', 'getbowtied'),
		'search_no_suggestions_text'   => esc_html__( 'No Results Found', 'getbowtied'),
		'transparent_header'		   => Merchandiser_Options::getOption( 'header_transparent', false ),
		'ajax_url' 					   => Merchandiser::get_ajax_url(),
	);

	wp_localize_script( 'getbowtied-scripts', 'getbowtied_scripts_vars', $getbowtied_scripts_vars_array );

	return;
}
add_action( 'wp_enqueue_scripts', 'merchandiser_enqueue_theme_scripts' );

/**
 * Enqueue theme admin scripts.
 *
 * @return void
 */
function merchandiser_enqueue_theme_admin_scripts() {
    if ( is_admin() ) {
		wp_enqueue_script('merchandiser-admin-scripts', get_template_directory_uri() .'/assets/js/admin/admin-scripts-dist.js', array('jquery'), Merchandiser::get_theme_version(), 'all');
    }
}
add_action( 'admin_enqueue_scripts', 'merchandiser_enqueue_theme_admin_scripts' );
