<?php
/*
 * Quickview functions.
 */

/*
 * WooCommerce Product Quick View - Load The Product.
 */
function merchandiser_product_quick_view() {

	if ( !isset( $_REQUEST['product_id'] )) {
		exit('No quickview product ID');
	}

	$product_id = intval($_REQUEST['product_id']);

	if( isset($_GET['wpml_lang']) )	{
		do_action( 'wpml_switch_language', $_GET[ 'wpml_lang' ] );
	}

	// wp_query for the product
	wp( 'p=' . $product_id . '&post_type=product' );

	ob_start();
	get_template_part( 'woocommerce/quick-view' );
	echo ob_get_clean();

	die();
}
add_action( 'wp_ajax_merchandiser_product_quick_view', 'merchandiser_product_quick_view');
add_action( 'wp_ajax_nopriv_merchandiser_product_quick_view', 'merchandiser_product_quick_view');

/*
 * WooCommerce Product Quick View - Show Quick View Button.
 * hooked in 'woocommerce_shop_loop_item_buttons'.
 */
function merchandiser_product_quick_view_button() {
	global $product;

	$prod_id = $product->get_id();
	?>
	<button id="product_id_<?php echo esc_attr($prod_id); ?>" class="button merchandiser_product_quick_view_button" data-product_id="<?php echo esc_attr($prod_id); ?>">
		<svg
			xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
			width="22" height="22"
			viewBox="0 0 24 24">
			<path d="M 12 4 C 4 4 1 12 1 12 C 1 12 4 20 12 20 C 20 20 23 12 23 12 C 23 12 20 4 12 4 z M 12 6 C 17.276 6 19.944594 10.267094 20.808594 11.996094 C 19.943594 13.713094 17.255 18 12 18 C 6.724 18 4.0554062 13.732906 3.1914062 12.003906 C 4.0574062 10.286906 6.745 6 12 6 z M 12 8 C 9.791 8 8 9.791 8 12 C 8 14.209 9.791 16 12 16 C 14.209 16 16 14.209 16 12 C 16 9.791 14.209 8 12 8 z M 12 10 C 13.105 10 14 10.895 14 12 C 14 13.105 13.105 14 12 14 C 10.895 14 10 13.105 10 12 C 10 10.895 10.895 10 12 10 z"></path>
		</svg>
	</button>
	<?php

    return;
}
