<?php

/*
 * WooCommerce Cart is empty remove notice class.
 */
remove_action('woocommerce_cart_is_empty', 'wc_empty_cart_message', 10);
add_action('woocommerce_cart_is_empty', 'merchandiser_empty_cart_message', 10);
function merchandiser_empty_cart_message() {
	echo '<p class="cart-empty">' . wp_kses_post( apply_filters( 'wc_empty_cart_message', __( 'Your cart is currently empty.', 'woocommerce' ) ) ) . '</p>';

	return;
}

/*
* Enable of disable Woo functionalities.
*/
function merchandiser_adjust_woocommerce_hooks() {
	// Cart
	remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
	remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals' );
	add_action( 'woocommerce_cart_collaterals', 'woocommerce_cart_totals' );
	add_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display', 20 );

	// Breadcrumbs
	remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );

	// Product Subcategory Thumbnails
	remove_action( 'woocommerce_before_subcategory_title', 'woocommerce_subcategory_thumbnail', 10 );

	return;
}
add_action('init', 'merchandiser_adjust_woocommerce_hooks');

/*
* Product loop - category image.
*/
function merchandiser_product_subcategory_image($category) {

	$shop_display_type = ( isset($_GET["s"]) && !empty($_GET["s"]) ) ? 'products' : woocommerce_get_loop_display_mode();
	$image = $thumbnail_id = '';
	if( 'subcategories' === $shop_display_type ) {
		$thumbnail_id = get_term_meta( $category->term_id, 'thumbnail_id', true  );
		if ( $thumbnail_id ) {
			$image = wp_get_attachment_image_src( $thumbnail_id, 'full'  );
			$image = isset($image[0]) ? str_replace( ' ', '%20', $image[0] ) : '';
		} else {
			// Prevent esc_url from breaking spaces in urls for image embeds
			$image = str_replace( ' ', '%20', wc_placeholder_img_src() );
		}
	}

	echo '<span class="category_img" style="background-image:url(' . esc_url($image) . ')"></span>';

	return;
}
add_action( 'woocommerce_before_subcategory', 'merchandiser_product_subcategory_image', 20 );

/*
 * WooCommerce Product Sale Badge.
 */
function merchandiser_product_badges() {
	global $product;

	echo '<div class="shop-product-badges">';
	wc_get_template( 'loop/sale-flash.php' );
	if( !$product->is_in_stock() && !empty( Merchandiser_Options::getOption( 'custom_out_of_stock_label', esc_html__('Out of stock', 'getbowtied' ) ) ) ) {
		printf( wp_kses_post( __( '<div class="out_of_stock">%s</div>', 'getbowtied' ) ), Merchandiser_Options::getOption( 'custom_out_of_stock_label', esc_html__('Out of stock', 'getbowtied' ) ) );
	}
	echo '</div>';

	return;
}

/*
* Shop Tools.
*/
function merchandiser_shop_tools() {
	?>
	<div class="shop-tools" id="shop_product_sort">
		<svg class="shop-tools-button" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
			<path d="M 7 2 L 2 7 L 6 7 L 6 13 L 8 13 L 8 7 L 12 7 L 7 2 z M 16 3 L 16 5 L 18 5 L 18 3 L 16 3 z M 16 7 L 16 9 L 18 9 L 18 7 L 16 7 z M 16 11 L 16 17 L 12 17 L 17 22 L 22 17 L 18 17 L 18 11 L 16 11 z M 6 15 L 6 17 L 8 17 L 8 15 L 6 15 z M 6 19 L 6 21 L 8 21 L 8 19 L 6 19 z"/>
		</svg>
		<?php do_action( 'woocommerce_before_shop_loop_catalog_ordering' ); ?>
	</div>

	<div class="shop-tools" id="shop_change_layout">
		<svg class="shop-tools-button <?php echo current_user_can('administrator') ? esc_attr__('reset-grid') : esc_attr__(''); ?>" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24">
			<path d="M 4 2 C 2.9069372 2 2 2.9069372 2 4 L 2 11 C 2 12.093063 2.9069372 13 4 13 L 9 13 C 10.093063 13 11 12.093063 11 11 L 11 4 C 11 2.9069372 10.093063 2 9 2 L 4 2 z M 15 2 C 13.906937 2 13 2.9069372 13 4 L 13 7 C 13 8.0930628 13.906937 9 15 9 L 20 9 C 21.093063 9 22 8.0930628 22 7 L 22 4 C 22 2.9069372 21.093063 2 20 2 L 15 2 z M 4 4 L 9 4 L 9 11 L 4 11 L 4 4 z M 15 4 L 20 4 L 20 7 L 15 7 L 15 4 z M 15 11 C 13.906937 11 13 11.906937 13 13 L 13 20 C 13 21.093063 13.906937 22 15 22 L 20 22 C 21.093063 22 22 21.093063 22 20 L 22 13 C 22 11.906937 21.093063 11 20 11 L 15 11 z M 15 13 L 20 13 L 20 20 L 15 20 L 15 13 z M 4 15 C 2.9069372 15 2 15.906937 2 17 L 2 20 C 2 21.093063 2.9069372 22 4 22 L 9 22 C 10.093063 22 11 21.093063 11 20 L 11 17 C 11 15.906937 10.093063 15 9 15 L 4 15 z M 4 17 L 9 17 L 9 20 L 4 20 L 4 17 z"/>
		</svg>
		<?php if(current_user_can('administrator')) { ?>
			<span class="tooltip-text"><?php esc_html_e( 'Reset grid to default' ,'getbowtied' ); ?></span>
		<?php } ?>
		<div class="shop-display-numbers">
			<span class="shop-display-number" data-newval="1"><?php echo esc_html('1'); ?></span>
			<span class="shop-display-number" data-newval="2"><?php echo esc_html('2'); ?></span>
			<span class="shop-display-number" data-newval="3"><?php echo esc_html('3'); ?></span>
			<span class="shop-display-number" data-newval="4"><?php echo esc_html('4'); ?></span>
			<span class="shop-display-number" data-newval="5"><?php echo esc_html('5'); ?></span>
			<span class="shop-display-number" data-newval="6"><?php echo esc_html('6'); ?></span>
		</div>
	</div>
	<?php

	return;
}
add_action( 'woocommerce_shop_loop_tools', 'merchandiser_shop_tools', 10 );

/*
* Wishlist Button.
*/
function merchandiser_product_wishlist_button() {
	?>
	<div class="shop_archive_wishlist">
		<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>
	</div>
	<?php

	return;
}

/*
* Moved Checkout order title to sidebar.
*/
function merchandiser_checkout_order_title() {
	?>
	<h3 id="order_review_heading"><?php esc_html_e( 'Your order', 'woocommerce' ); ?></h3>
	<?php

	return;
}
add_action( 'woocommerce_checkout_order_review', 'merchandiser_checkout_order_title', 0 );

/*
 * Show Woocommerce Cart Widget Everywhere.
 */
function merchandiser_woocommerce_widget_cart_everywhere() {
    return false;
};
add_filter( 'woocommerce_widget_cart_is_hidden', 'merchandiser_woocommerce_widget_cart_everywhere', 10, 1 );

/*
 * WooCommerce Cross Sell Columns.
 */
function merchandiser_cross_sells_columns( $columns ) {
	return 3;
}
add_filter( 'woocommerce_cross_sells_columns', 'merchandiser_cross_sells_columns' );

/*
 * WooCommerce Post Count Filter.
 */
function merchandiser_categories_postcount_filter($variable) {
	$variable = str_replace('(', '', $variable);
	$variable = str_replace(')', '', $variable);

	return $variable;
}
add_filter( 'wp_list_categories', 'merchandiser_categories_postcount_filter' );

/*
 * WooCommerce Layered Nav Filter.
 */
function merchandiser_layered_nav_postcount_filter($variable) {
	$variable = str_replace('(', '', $variable);
	$variable = str_replace(')', '', $variable);

	return $variable;
}
add_filter( 'woocommerce_layered_nav_count', 'merchandiser_layered_nav_postcount_filter' );

/*
 * WooCommerce Reviews Tab.
 */
function merchandiser_rename_reviews_tab($tabs) {
	global $product, $post;
	$reviews_tab_title = esc_html__( 'Reviews', 'woocommerce' ) . '<sup>' . $product->get_review_count() . '</sup>';

	return $reviews_tab_title;
}
add_filter( 'woocommerce_product_reviews_tab_title', 'merchandiser_rename_reviews_tab', 98);

/*
 * WooCommerce Breadcrumb.
 */
function merchandiser_custom_breadcrumb($defaults) {
	$defaults['delimiter'] = '<span>&nbsp;&nbsp;&nbsp;/&nbsp;&nbsp;&nbsp;</span>';
	$defaults['wrap_before'] = '<nav class="woocommerce-breadcrumb">';

	return $defaults;
}
add_filter( 'woocommerce_breadcrumb_defaults', 'merchandiser_custom_breadcrumb' );

/*
 * Custom WooCommerce upsells.
 */
function merchandiser_output_upsells() {
	?>
	<div class="row">
		<div class="large-812 large-centered columns">
			<?php woocommerce_upsell_display( 3,3 ); // Display 3 products in rows of 3 ?>
    	</div>
    </div>
	<?php

	return;
}

/*
 * Custom WooCommerce related products.
 */
function merchandiser_output_related() {
	?>
	<div class="row">
		<div class="large-12 large-centered columns">
			<?php
			if ( function_exists( 'woocommerce_related_products' ) ) {
				
				woocommerce_related_products( array(
					'columns'		 => '3',
					'posts_per_page' => '3',
					'orderby'        => 'rand'
				) ); // Display 3 products in rows of 3
				
			}
		    ?>
    	</div>
    </div>
	<?php

	return;
}

/*
 * Custom Sale label.
 */
function merchandiser_custom_sale_tag_sale_flash($original, $post, $product) {
	if( !empty( Merchandiser_Options::getOption( 'custom_sale_label', esc_html__('Sale!', 'getbowtied' ) ) ) ) {
		printf( wp_kses_post( __( '<span class="onsale">%s</span>', 'getbowtied' ) ), Merchandiser_Options::getOption( 'custom_sale_label', esc_html__('Sale!', 'getbowtied' ) ) );
	}

	return;
}
add_filter('woocommerce_sale_flash', 'merchandiser_custom_sale_tag_sale_flash', 10, 3);

/*
 * WooCommerce Update Number of Items in the Cart.
 */
function merchandiser_shopping_bag_items_number($fragments) {
	global $woocommerce;
	ob_start(); ?>

    <span class="shopping_bag_items_number visible animated jello"><?php echo esc_html(WC()->cart->get_cart_contents_count()); ?></span>

	<?php
	$fragments['.shopping_bag_items_number'] = ob_get_clean();

	return $fragments;
}
add_filter('woocommerce_add_to_cart_fragments', 'merchandiser_shopping_bag_items_number');

/*
 * WooCommerce Remove Tabs Titles.
 */
add_filter( 'woocommerce_product_description_heading', function() {
	echo '';
} );

add_filter( 'woocommerce_product_additional_information_heading', function() {
	echo '';
} );

/*
 * WooCommerce Out of Stock badge.
 */
function merchandiser_out_of_stock_badge() {
	global $product;

	if( !$product->is_in_stock() && !empty( Merchandiser_Options::getOption( 'custom_out_of_stock_label', esc_html__('Out of stock', 'getbowtied' ) ) ) ) {
		printf( wp_kses_post( __( '<div class="out_of_stock">%s</div>', 'getbowtied' ) ), Merchandiser_Options::getOption( 'custom_out_of_stock_label', esc_html__('Out of stock', 'getbowtied' ) ) );
	}

	return;
}

/*
 * WooCommerce Product Gallery Args.
 */
function merchandiser_product_carousel_options($options) {
	$options['animationLoop'] = false;
	$options['simulateTouch'] = true;

	return $options;
}
add_filter( 'woocommerce_single_product_carousel_options', 'merchandiser_product_carousel_options', 10 );
