<?php

/*
 * Add Lightbox to WP Gallery.
 */
function merchandiser_add_lightbox_to_gallery ($content, $id, $size, $permalink, $icon, $text) {

    return $permalink ? $content : preg_replace('/<a/', '<a data-lightbox="gallery"', $content, 1) ;
}
add_filter( 'wp_get_attachment_link', 'merchandiser_add_lightbox_to_gallery', 10, 6);

/*
 * Archives Count Filter.
 */
function merchandiser_archive_count_filter($links) {
	$links = str_replace('</a>&nbsp;(', '</a><span class="count">', $links);
	$links = str_replace(')', '</span>', $links);

	return $links;
}
add_filter('get_archives_link', 'merchandiser_archive_count_filter');

/*
 * Excerpt Length Filter.
 */
add_filter( 'excerpt_length', function() {
    return 15;
}, 999 );

/*
 * Excerpt Read More End Filter.
 */
add_filter( 'excerpt_more', function() {
    return '...';
} );

/*
 * Menu dropdown arrows.
 */
function merchandiser_add_menu_dropdown_arrow( $output, $item, $depth, $args ) {
    // Only add class to 'top level' items on the 'primary' menu.
    if( ( 'primary' === $args->theme_location ) && ( $depth === 0 ) && in_array( "menu-item-has-children", $item->classes ) ) {
        $output .='<span class="sub-menu-icon"><svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 24 24"><path d="M 7.4296875 9.5 L 5.9296875 11 L 12 17.070312 L 18.070312 11 L 16.570312 9.5 L 12 14.070312 L 7.4296875 9.5 z"></path></svg></span>';
    }

    return $output;
}
add_filter( 'walker_nav_menu_start_el', 'merchandiser_add_menu_dropdown_arrow', 10, 4 );
