<?php $header_layout = ( 'header_1' === Merchandiser_Options::getOption( 'header_layout', 'header_2' ) ) ? 'header-1' :'header-2'; ?>

<header class="site-header">

    <div class="header-wrapper <?php echo esc_attr($header_layout); ?>">
        <?php

        merchandiser_get_header_navigation();
        merchandiser_get_header_identity();
		merchandiser_get_header_icons();

        ?>
    </div>

    <div class="search_wrapper" aria-hidden="true">
	    <div class="getbowtied_search_bar">
	        <?php if( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE ) { ?>
                <div class="<?php echo Merchandiser_Options::getOption( 'shop_predictive_search', true ) ? 'getbowtied-ajaxsearchform-container' : 'searchform-container'; ?>">
                    <?php get_product_search_form(); ?>
                </div>
            <?php } else { ?>
                <?php get_search_form(true); ?>
            <?php } ?>
	    </div>

	    <ul class="search-widget-area widget-area adjust_cols_height">
	        <?php dynamic_sidebar( 'search-widget-area' ); ?>
	    </ul>
    </div>

    <?php if ( ! is_user_logged_in() && MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && !(is_account_page()) && !(is_checkout()) ) { ?>
        <?php remove_action( 'woocommerce_before_customer_login_form', 'woocommerce_output_all_notices', 10 ); ?>
        <div class="myaccount-popup">
            <div class="woocommerce-account">
                <div class="woocommerce">
                    <?php wc_get_template( 'myaccount/form-login.php' ); ?>
                </div>
            </div>
        </div>
    <?php } ?>

</header>
