<?php
/**
 * Customizer config
 */

 /**
  * Load presets
 */
$preset = isset($_GET["preset"]) ? $_GET["preset"] : '';
if ( !empty($preset) ) {
 	if ( file_exists( get_template_directory() . '/_presets/'.$preset.'.dat' ) ) {
	 	$presets_raw = Merchandiser::get_local_file_contents(get_template_directory() . '/_presets/'.$preset.'.dat');
	 	$presets = @unserialize( $presets_raw );
 	}
}

/**
 * Remove Native Sections and Controls
*/
add_action( 'customize_register', 'merchandiser_customizer_config' );
function merchandiser_customizer_config( $wp_customize ) {

	$wp_customize->remove_section('colors');
	$wp_customize->remove_section('background_image');
	$wp_customize->remove_section('header_image');

	$wp_customize->remove_control('header_textcolor');
	$wp_customize->remove_control('background_color');
	$wp_customize->remove_control('display_header_text');

	return;
}

/**
 * Remove Customize Pages
*/
add_action('admin_menu', 'merchandiser_remove_customize_pages');
function merchandiser_remove_customize_pages(){
	global $submenu;

	unset($submenu['themes.php'][15]); // remove Header link
	unset($submenu['themes.php'][20]); // remove Background link

	return;
}

/**
 * Sets the customizer sections
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_sections( $wp_customize ) {

   // Header.
   $wp_customize->add_panel( 'panel_header', array(
       'title'          => esc_html__( 'Header', 'getbowtied' ),
       'priority'       => 1,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'header_style', array(
       'title'          => esc_attr__( 'Header Styles', 'getbowtied' ),
       'priority'       => 2,
       'capability'     => 'edit_theme_options',
       'panel'          => 'panel_header',
   ) );

   $wp_customize->add_section( 'header_logo', array(
       'title'          => esc_attr__( 'Header Logo', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
       'panel'          => 'panel_header',
   ) );

   $wp_customize->add_section( 'header_elements', array(
       'title'          => esc_attr__( 'Header Elements', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
       'panel'          => 'panel_header',
   ) );

   $wp_customize->add_section( 'header_stickiness', array(
       'title'          => esc_attr__( 'Header Stickiness', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
       'panel'          => 'panel_header',
   ) );

   $wp_customize->add_section( 'header_transparency', array(
       'title'          => esc_attr__( 'Header Transparency', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
       'panel'          => 'panel_header',
   ) );

   $wp_customize->add_section( 'fonts', array(
       'title'          => esc_attr__( 'Fonts', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'colors', array(
       'title'          => esc_attr__( 'Colors', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'blog', array(
       'title'          => esc_attr__( 'Blog', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'shop', array(
       'title'          => esc_attr__( 'Shop', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

    $wp_customize->add_section( 'product_category', array(
       'title'          => esc_attr__( 'Product Category', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'product', array(
       'title'          => esc_attr__( 'Product Page', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );

   $wp_customize->add_section( 'footer', array(
       'title'          => esc_attr__( 'Footer', 'getbowtied' ),
       'priority'       => 10,
       'capability'     => 'edit_theme_options',
   ) );
}
add_action( 'customize_register','merchandiser_customizer_sections' );


/**
 * Go To Page
 */
function merchandiser_get_customize_section_url() {
	switch($_POST['page']) {
		case 'shop':
			echo get_permalink( wc_get_page_id( 'shop' ) );
			break;
		case 'blog':
			echo get_permalink( get_option( 'page_for_posts' ) );
			break;
		case 'product':
			$args = array('orderby' => 'rand', 'limit' => 1);
			$product = wc_get_products($args);
			echo get_permalink( $product[0]->get_id() );
			break;
		case 'product_category':
            $args = array('taxonomy' => 'product_cat', 'orderby' => 'rand', 'limit' => 1);
            $categories = get_categories($args);
            echo get_term_link($categories[0]->slug, 'product_cat');
			break;
		default:
			echo get_home_url();
			break;
	}
	exit();
}
add_action( 'wp_ajax_merchandiser_get_section_url', 'merchandiser_get_customize_section_url' );
?>
