<?php
/**
* The Header Sticky section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_header_sticky_controls' );
/**
 * Adds controls for header sticky section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_header_sticky_controls( $wp_customize ) {

    // Sticky Header.
    $wp_customize->add_setting(
		'header_sticky',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_sticky',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Sticky Header', 'getbowtied' ),
				'section'       => 'header_stickiness',
				'priority'       => 10,
			)
		)
	);
}

?>
