<?php
/**
* The Header Styles section options.
*/

/**
 * Checks if navigation alignment is needed.
 */
function merchandiser_header_alignment(){
   if( ( 'header_1' === Merchandiser_Options::getOption( 'header_layout', 'header_2' ) ) && ( 'flyout' === Merchandiser_Options::getOption( 'header_navigation_style', 'slices' ) ) ) {
       return true;
   }
   return false;
}

add_action( 'customize_register', 'merchandiser_customizer_header_styles_controls' );
/**
 * Adds controls for header styles section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_header_styles_controls( $wp_customize ) {

    // Header Layout.
    $wp_customize->add_setting(
        'header_layout',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'header_2',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_layout',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Header Layout', 'getbowtied' ),
                'section'  => 'header_style',
                'priority' => 10,
                'choices'  => array(
                    'header_1'        => esc_html__( 'Layout 1', 'getbowtied' ),
                    'header_2'        => esc_html__( 'Layout 2', 'getbowtied' ),
                ),
            )
        )
    );

    // Navigation Style.
    $wp_customize->add_setting(
        'header_navigation_style',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'slices',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_navigation_style',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Navigation Style', 'getbowtied' ),
                'section'  => 'header_style',
                'priority' => 10,
                'choices'  => array(
                    'flyout'        => esc_html__( 'Dropdown Menus', 'getbowtied' ),
                    'slices'        => esc_html__( 'Mega Menus', 'getbowtied' ),
                ),
            )
        )
    );

    // Navigation Alignment.
    $wp_customize->add_setting(
        'header_navigation_alignment',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'align_left',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_navigation_alignment',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Navigation Alignment', 'getbowtied' ),
                'section'  => 'header_style',
                'priority' => 10,
                'choices'  => array(
                    'align_left'        => esc_html__( 'Left', 'getbowtied' ),
                    'align_right'        => esc_html__( 'Right', 'getbowtied' ),
                ),
                'active_callback' => 'merchandiser_header_alignment',
            )
        )
    );

    // Header Size.
    $wp_customize->add_setting(
        'header_height',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 75,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_height',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Header Size', 'getbowtied' ),
                'section'     => 'header_style',
                'priority'    => 10,
                'description' => esc_html__( "(20px - 250px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 20,
                    'max'  => 250,
                    'step' => 1,
                ),
            )
        )
    );

    // Header Background Color.
    $wp_customize->add_setting(
        'header_background_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#23282d',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'header_background_color',
            array(
                'label'    => esc_html__( 'Header Background Color', 'getbowtied' ),
                'section'  => 'header_style',
                'priority' => 10,
            )
        )
    );

    // Header Font Size.
    $wp_customize->add_setting(
        'header_font_size',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 13,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_font_size',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Header Font Size', 'getbowtied' ),
                'section'     => 'header_style',
                'priority'    => 10,
                'description' => esc_html__( "(9px - 18px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 9,
                    'max'  => 18,
                    'step' => 1,
                ),
            )
        )
    );

    // Header Font Color.
    $wp_customize->add_setting(
        'header_font_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'header_font_color',
            array(
                'label'    => esc_html__( 'Header Font Color', 'getbowtied' ),
                'section'  => 'header_style',
                'priority' => 10,
            )
        )
    );

    // Dropdown Font Size.
    $wp_customize->add_setting(
        'header_dropdown_font_size',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 13,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_dropdown_font_size',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Dropdown Font Size', 'getbowtied' ),
                'section'     => 'header_style',
                'priority'    => 10,
                'description' => esc_html__( "(9px - 18px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 9,
                    'max'  => 18,
                    'step' => 1,
                ),
            )
        )
    );
}

?>
