<?php
/**
* The Header Transparency section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_header_transparency_controls' );
/**
 * Adds controls for header transparency section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_header_transparency_controls( $wp_customize ) {

    // Transparent Header.
    $wp_customize->add_setting(
		'header_transparent',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => false,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_transparent',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Transparent Header', 'getbowtied' ),
                'description'        => esc_html__( 'This option here will be inherited by all pages that do not have a different setting applied individually for the header.', 'getbowtied' ),
				'section'       => 'header_transparency',
				'priority'       => 10,
			)
		)
	);

    // Use Default Logo in Sticky Header.
    $wp_customize->add_setting(
		'header_transparent_sticky_default_logo',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => false,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'header_transparent_sticky_default_logo',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Use Alternative Logo in Sticky Header', 'getbowtied' ),
				'section'       => 'header_transparency',
				'priority'       => 10,
			)
		)
	);

    // Default Color Scheme.
    $wp_customize->add_setting(
        'header_transparent_scheme',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'dark',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'header_transparent_scheme',
            array(
                'type'          => 'select',
                'label'         => esc_html__( 'Default Color Scheme', 'getbowtied' ),
                'description'   => esc_html__( 'The transparent header comes with two different color schemes: Light and Dark. For both you can choose to have a different color for the header content (navigation, icons, etc) and even a different logo. The option here sets the one you want to use as the default. The other can be set as an exception to be used by some pages only.', 'getbowtied' ),
                'section'       => 'header_transparency',
                'priority'      => 10,
                'choices'       => array(
                    'light'   => esc_attr__( 'Light', 'getbowtied' ),
                    'dark'    => esc_attr__( 'Dark', 'getbowtied' ),
                ),
            )
        )
    );

    // Light Scheme: Color.
    $wp_customize->add_setting(
        'header_transparent_light_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffffff',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'header_transparent_light_color',
            array(
                'label'          => esc_html__( 'Light Scheme: Color', 'getbowtied' ),
                'description'    => esc_html__( 'If the page you are working on has a dark background, using a dark color for the menu items would make it unreadable and that is where the Light color scheme comes in. (E.g.: White text on a Black background.)' , 'getbowtied' ),
                'section'        => 'header_transparency',
                'priority'       => 10,
            )
        )
    );

    // Logo for Light Scheme.
    $wp_customize->add_setting(
        'header_transparent_light_logo',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_transparent_light_logo',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Logo for Light Scheme', 'getbowtied' ),
                'section'     => 'header_transparency',
                'priority'    => 10,
            )
        )
    );

    $wp_customize->selective_refresh->add_partial( 'header_transparent_light_logo', array(
        'selector' => '.header-transparent.header-transparent-light .site-header .site-logo',
        'settings' => 'header_transparent_light_logo',
        'render_callback' => function() {
            merchandiser_get_header_logo('default');
        },
    ) );

    // Dark Scheme: Color.
    $wp_customize->add_setting(
        'header_transparent_dark_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#000000',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'header_transparent_dark_color',
            array(
                'label'          => esc_html__( 'Dark Scheme: Color', 'getbowtied' ),
                'description'    => esc_html__( 'If the page you are working on has a light backgeround, using a light color for the menu items as well would make it unreadable and that is where the Dark color scheme comes in. (E.g.: Black text on a White background.)' , 'getbowtied' ),
                'section'        => 'header_transparency',
                'priority'       => 10,
            )
        )
    );

    // Logo for Dark Scheme.
    $wp_customize->add_setting(
        'header_transparent_dark_logo',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_image',
            'default'	        => '',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Image_Control(
            $wp_customize,
            'header_transparent_dark_logo',
            array(
                'type'        => 'image',
                'label'       => esc_html__( 'Logo for Dark Scheme', 'getbowtied' ),
                'section'     => 'header_transparency',
                'priority'    => 10,
            )
        )
    );

    $wp_customize->selective_refresh->add_partial( 'header_transparent_dark_logo', array(
        'selector' => '.header-transparent.header-transparent-dark .site-header .site-logo',
        'settings' => 'header_transparent_dark_logo',
        'render_callback' => function() {
            merchandiser_get_header_logo('default');
        },
    ) );
}

?>
