<?php
/**
* The Blog section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_blog_controls' );
/**
 * Adds controls for blog section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_blog_controls( $wp_customize ) {

    // Blog Layout.
    $wp_customize->add_setting(
        'blog_layout',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'blog_layout_default',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'blog_layout',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Blog Layout', 'getbowtied' ),
                'section'  => 'blog',
                'priority' => 10,
                'choices'  => array(
                    'blog_layout_default'  => esc_html__( 'Layout 1', 'getbowtied' ),
                    'blog_layout_1'        => esc_html__( 'Layout 2', 'getbowtied' ),
                    'blog_layout_2'        => esc_html__( 'Layout 3', 'getbowtied' ),
                ),
            )
        )
    );

    // Pagination.
    $wp_customize->add_setting(
        'blog_pagination',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'infinite_scroll',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'blog_pagination',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Pagination', 'getbowtied' ),
                'section'  => 'blog',
                'priority' => 10,
                'choices'  => array(
                    'default'           => esc_attr__( 'Classic', 'getbowtied' ),
                    'load_more_button'  => esc_attr__( 'Load More', 'getbowtied' ),
                    'infinite_scroll'   => esc_attr__( 'Infinite', 'getbowtied' ),
                ),
            )
        )
    );

    // Single Post: Feature Image Style.
    $wp_customize->add_setting(
        'single_post_layout',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'single_post_2',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'single_post_layout',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Single Post: Featured Image Style', 'getbowtied' ),
                'section'  => 'blog',
                'priority' => 10,
                'choices'  => array(
                    'single_post_1'  => esc_attr__( 'Full Width', 'getbowtied' ),
                    'single_post_2'  => esc_attr__( 'Wide Width', 'getbowtied' ),
                ),
            )
        )
    );
}

?>
