<?php
/**
* The Fonts section options.
*/

/**
 * Checks if default theme fonts are selected.
 */
function merchandiser_default_fonts_selected(){

    return ( 'default_fonts' === Merchandiser_Options::getOption( 'default_theme_fonts', 'default_fonts' ) );
}

/**
 * Checks if google fonts are selected.
 */
function merchandiser_google_fonts_selected(){

    return ( 'google_fonts' === Merchandiser_Options::getOption( 'default_theme_fonts', 'default_fonts' ) );
}

add_action( 'customize_register', 'merchandiser_customizer_fonts_controls' );
/**
 * Adds controls for fonts section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_fonts_controls( $wp_customize ) {

    // Base Font Size.
    $wp_customize->add_setting(
        'font_size',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 18,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'font_size',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Base Font Size', 'getbowtied' ),
                'description' => esc_attr__( 'The Base Font Size refers to the size applied to the paragraph text. All other elements, such as headings, links, buttons, etc will adjusted automatically to keep the hierarchy of font sizes based on this one size. Easy-peasy!', 'getbowtied' ),
                'section'     => 'fonts',
                'priority'    => 10,
                'description' => esc_html__( "(8px - 32px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 8,
                    'max'  => 32,
                    'step' => 1,
                ),
            )
        )
    );

    // Font Display.
    $wp_customize->add_setting(
        'fonts_font_face_display',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'swap',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'fonts_font_face_display',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Font Display', 'getbowtied' ),
                'section'  => 'fonts',
                'description' => '<ul><li>'.esc_html__( 'Swap - uses fallback font until the fonts area loaded', 'getbowtied' ).'</li><li>'.esc_html__( 'Block - briefly hides the text until the font is fully loaded', 'getbowtied' ).'</li></ul>',
                'priority' => 10,
                'choices'  => array(
                    'swap'       => esc_html__( 'Use fallback font (swap)', 'getbowtied' ),
                    'block'      => esc_html__( 'Hide text while loading (block)', 'getbowtied' ),
                ),
            )
        )
    );

    // Font Source.
    $wp_customize->add_setting(
        'default_theme_fonts',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'default_fonts',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'default_theme_fonts',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Font Source', 'getbowtied' ),
                'section'  => 'fonts',
                'priority' => 10,
                'choices'  => array(
                    'default_fonts' => esc_attr__( 'Theme Defaults', 'getbowtied' ),
                    'google_fonts'  => esc_attr__( 'Google Webfonts', 'getbowtied' ),
                ),
            )
        )
    );

    // Font Source.
    $wp_customize->add_setting(
        'default_fonts_variant',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => '2',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'default_fonts_variant',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Fonts', 'getbowtied' ),
                'section'  => 'fonts',
                'priority' => 10,
                'choices'  => array(
                    '1'         => esc_attr__( 'Poppins / PT Serif', 'getbowtied' ),
                    '2'         => esc_attr__( 'Arca Majora / Radnika', 'getbowtied' ),
                ),
                'active_callback' => 'merchandiser_default_fonts_selected',
            )
        )
    );

    // Main Font.
	$wp_customize->add_setting(
		'new_main_font',
		array(
			'default' 			=> 'Roboto',
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			'type'				=> 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'new_main_font',
			array(
				'type'			=> 'text',
				'label' 		=> __( 'Main Font', 'getbowtied' ),
				'description'	=> Merchandiser_Fonts::get_suggested_fonts_list() . 'Used for titles and Headings. Merchandiser supports all fonts on <a href="'.MERCHANDISER_GOOGLE_FONTS_WEBSITE.'" target="_blank">Google Fonts</a> and all <a href="'.MERCHANDISER_SAFE_FONTS_WEBSITE.'" target="_blank">web safe fonts</a>.',
				'section' 		=> 'fonts',
				'input_attrs' 	=> array(
					'placeholder' 		=> __( 'Enter the font name', 'getbowtied' ),
					'class'				=> 'merchandiser-font-suggestions',
					'list'  			=> 'merchandiser-suggested-fonts',
					'autocapitalize'	=> 'off',
					'autocomplete'		=> 'off',
					'autocorrect'		=> 'off',
					'spellcheck'		=> 'false',
				),
                'active_callback' => 'merchandiser_google_fonts_selected',
			)
		)
	);

    // Secondary Font.
	$wp_customize->add_setting(
		'new_secondary_font',
		array(
			'default' 			=> 'Roboto',
			'capability' 		=> 'edit_theme_options',
			'sanitize_callback' => 'wp_filter_nohtml_kses',
			'type'				=> 'theme_mod',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'new_secondary_font',
			array(
				'type'			=> 'text',
				'label' 		=> __( 'Secondary Font', 'getbowtied' ),
				'description'	=> Merchandiser_Fonts::get_suggested_fonts_list() . 'Used for body / paragraph text. Merchandiser supports all fonts on <a href="'.MERCHANDISER_GOOGLE_FONTS_WEBSITE.'" target="_blank">Google Fonts</a> and all <a href="'.MERCHANDISER_SAFE_FONTS_WEBSITE.'" target="_blank">web safe fonts</a>.',
				'section' 		=> 'fonts',
				'input_attrs' 	=> array(
					'placeholder' 		=> __( 'Enter the font name', 'getbowtied' ),
					'class'				=> 'merchandiser-font-suggestions',
					'list'  			=> 'merchandiser-suggested-fonts',
					'autocapitalize'	=> 'off',
					'autocomplete'		=> 'off',
					'autocorrect'		=> 'off',
					'spellcheck'		=> 'false',
				),
                'active_callback' => 'merchandiser_google_fonts_selected',
			)
		)
	);
}

?>
