<?php
/**
* The Product Category section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_product_category_controls' );
/**
 * Adds controls for product category section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_product_category_controls( $wp_customize ) {

    // Category Header Height.
    $wp_customize->add_setting(
        'category_height',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 150,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'category_height',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Category Header Image Spacing', 'getbowtied' ),
                'section'     => 'product_category',
                'priority'    => 10,
                'description' => esc_html__( "(75px - 200px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 75,
                    'max'  => 200,
                    'step' => 1,
                ),
            )
        )
    );

    // Shop Category Page Color Scheme.
    $wp_customize->add_setting(
        'category_transparency',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'inherit',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'category_transparency',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Shop Category Page Color Scheme', 'getbowtied' ),
                'section'  => 'product_category',
                'priority' => 10,
                'choices'  => array(
                    'inherit'               => esc_attr__( 'Inherit', 'getbowtied' ),
                    'no_transparency'       => esc_attr__( 'No Transparency', 'getbowtied' ),
                    'transparency_light'    => esc_attr__( 'Light', 'getbowtied' ),
                    'transparency_dark'     => esc_attr__( 'Dark', 'getbowtied' ),
                ),
            )
        )
    );
}

?>
