<?php
/**
* The Product Page section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_product_page_controls' );
/**
 * Adds controls for product page section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_product_page_controls( $wp_customize ) {

    // Product Image Gallery.
    $wp_customize->add_setting(
        'product_image_gallery',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'half_page',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'product_image_gallery',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Product Image Gallery', 'getbowtied' ),
                'section'  => 'product',
                'priority' => 10,
                'choices'  => array(
                    'classic'    => esc_attr__( 'Classic', 'getbowtied' ),
                    'half_page'  => esc_attr__( 'Half Page', 'getbowtied' ),
                ),
            )
        )
    );

    // Enable image zoom.
    $wp_customize->add_setting(
        'product_image_zoom',
        array(
            'type'                 => 'theme_mod',
            'capability'           => 'edit_theme_options',
            'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
            'default'              => true,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'product_image_zoom',
            array(
                'type'          => 'checkbox',
                'label'         => esc_html__( 'Enable image zoom', 'getbowtied' ),
                'section'       => 'product',
                'priority'      => 10,
            )
        )
    );

    // Show Related Products.
    $wp_customize->add_setting(
        'related_products',
        array(
            'type'                 => 'theme_mod',
            'capability'           => 'edit_theme_options',
            'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
            'default'              => true,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'related_products',
            array(
                'type'          => 'checkbox',
                'label'         => esc_html__( 'Show Related Products', 'getbowtied' ),
                'section'       => 'product',
                'priority'      => 10,
            )
        )
    );
}

?>
