<?php
/**
* The Shop section options.
*/

add_action( 'customize_register', 'merchandiser_customizer_shop_controls' );
/**
 * Adds controls for shop section.
 *
 * @param  [object] $wp_customize [customizer object].
 */
function merchandiser_customizer_shop_controls( $wp_customize ) {

    // Catalog Mode.
    $wp_customize->add_setting(
		'catalog_mode',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => false,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'catalog_mode',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Catalog Mode', 'getbowtied' ),
                'description'   => esc_html__( 'When turned on, the Catalog Mode disables the eCommerce functionality of WooCommerce by hiding the cart and add to cart buttons allowing you to use it for cataloging purposes only.', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Shop Layout Style.
    $wp_customize->add_setting(
        'shop_layout_style',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'regular',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'shop_layout_style',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Shop Layout Style', 'getbowtied' ),
                'section'  => 'shop',
                'priority' => 10,
                'choices'  => array(
                    'regular'           => esc_html__( 'Regular', 'getbowtied' ),
                    'masonry_style'     => esc_html__( 'Masonry', 'getbowtied' ),
                ),
            )
        )
    );

    // Shop Sidebar.
    $wp_customize->add_setting(
		'shop_sidebar',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_sidebar',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Shop Sidebar', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Spacing between products.
    $wp_customize->add_setting(
        'products_spacing',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'absint',
            'default'           => 0,
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'products_spacing',
            array(
                'type'        => 'number',
                'label'       => esc_html__( 'Spacing between products', 'getbowtied' ),
                'section'     => 'shop',
                'priority'    => 10,
                'description' => esc_html__( "(0px - 50px)", 'getbowtied' ),
                'input_attrs' => array(
                    'min'  => 0,
                    'max'  => 50,
                    'step' => 1,
                ),
            )
        )
    );

    // Pagination.
    $wp_customize->add_setting(
        'shop_pagination',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'Merchandiser::sanitize_select',
            'default'           => 'infinite_scroll',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'shop_pagination',
            array(
                'type'     => 'select',
                'label'    => esc_html__( 'Pagination', 'getbowtied' ),
                'section'  => 'shop',
                'priority' => 10,
                'choices'  => array(
                    'default'   		=> esc_attr__( 'Classic', 'getbowtied' ),
                    'load_more_button' 	=> esc_attr__( 'Load More', 'getbowtied' ),
                    'infinite_scroll' 	=> esc_attr__( 'Infinite', 'getbowtied' ),
                ),
            )
        )
    );

    // Predictive Search.
    $wp_customize->add_setting(
		'shop_predictive_search',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_predictive_search',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Predictive Search', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Title and Price.
    $wp_customize->add_setting(
		'shop_product_details',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_product_details',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Title and Price', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Quick View.
    $wp_customize->add_setting(
		'shop_quick_view',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_quick_view',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Quick View', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);


    // Show a 2nd image on hover.
    $wp_customize->add_setting(
		'shop_second_image',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_second_image',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Show a 2nd image on hover', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Sale Label.
    $wp_customize->add_setting(
        'custom_sale_label',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'wp_filter_nohtml_kses',
            'default'           => esc_html__( 'Sale!', 'getbowtied' ),
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'custom_sale_label',
            array(
                'type'        => 'text',
                'label'       => esc_attr__( 'Sale Badge Label', 'getbowtied' ),
                'section'     => 'shop',
                'priority'    => 10,
            )
        )
    );

    // Sale Badge Color.
    $wp_customize->add_setting(
        'custom_sale_color',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'sanitize_hex_color',
            'default'           => '#ffc741',
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Color_Control(
            $wp_customize,
            'custom_sale_color',
            array(
                'label'    => esc_html__( 'Sale Badge Color', 'getbowtied' ),
                'section'  => 'shop',
                'priority' => 10,
            )
        )
    );

    // Out of Stock Label.
    $wp_customize->add_setting(
        'custom_out_of_stock_label',
        array(
            'type'              => 'theme_mod',
            'capability'        => 'edit_theme_options',
            'sanitize_callback' => 'wp_filter_nohtml_kses',
            'default'           => esc_html__( 'Out of stock', 'getbowtied' ),
        )
    );

    $wp_customize->add_control(
        new WP_Customize_Control(
            $wp_customize,
            'custom_out_of_stock_label',
            array(
                'type'        => 'text',
                'label'       => esc_attr__( 'Out of Stock Badge Label', 'getbowtied' ),
                'section'     => 'shop',
                'priority'    => 10,
            )
        )
    );

    // Product shadow on hover.
    $wp_customize->add_setting(
		'shop_hover_shadow',
		array(
			'type'                 => 'theme_mod',
			'capability'           => 'edit_theme_options',
			'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
			'default'              => true,
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Control(
			$wp_customize,
			'shop_hover_shadow',
			array(
				'type'          => 'checkbox',
				'label'         => esc_html__( 'Product shadow on hover', 'getbowtied' ),
				'section'       => 'shop',
				'priority'      => 10,
			)
		)
	);

    // Open Minicart on Add to Cart.
    $wp_customize->add_setting(
    	'open_minicart',
    	array(
    		'type'                 => 'theme_mod',
    		'capability'           => 'edit_theme_options',
    		'sanitize_callback'    => 'Merchandiser::sanitize_checkbox',
    		'default'              => true,
    	)
    );

    $wp_customize->add_control(
    	new WP_Customize_Control(
    		$wp_customize,
    		'open_minicart',
    		array(
    			'type'          => 'checkbox',
    			'label'         => esc_html__( 'Open \'Mini Cart\' after clicking \'Add to Cart\'', 'getbowtied' ),
    			'section'       => 'shop',
    			'priority'      => 10,
    		)
    	)
    );
}

?>
