<?php
/**
* Custom template tags.
*/

/**
* Displays post comments.
*
* @param array   $comment
* @param boolean $args
* @param integer $depth
*/
function merchandiser_output_comments( $comment, $args, $depth ) {
    $GLOBALS['comment'] = $comment;

    if ( 'pingback' == $comment->comment_type || 'trackback' == $comment->comment_type ) { ?>

        <li id="comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
            <div class="comment-body">
                <?php esc_html_e( 'Pingback:', 'getbowtied' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( esc_html__( 'Edit', 'getbowtied' ), '<span class="edit-link">', '</span>' ); ?>
            </div>

    <?php } else { ?>

        <li id="comment-<?php comment_ID(); ?>" <?php comment_class( empty( $args['has_children'] ) ? '' : 'parent' ); ?>>
            <article id="div-comment-<?php comment_ID(); ?>" class="comment-body">

                <div class="comment-content">

                        <div class="author-info">

                            <div class="comment-author-avatar">
                                <?php echo get_avatar( $comment, 140 ); ?>
                            </div><!-- .comment-author-avatar -->

                            <?php if ( '0' == $comment->comment_approved ) : ?>
                                <p class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'getbowtied' ); ?></p>
                            <?php endif; ?>

                            <?php printf( esc_html__( '%s', 'getbowtied' ), sprintf( '<h3 class="comment-author">%s</h3>', get_comment_author_link() ) ); ?>

                            <div class="comment-metadata">
                                <a href="<?php echo esc_url( get_comment_link( $comment->comment_ID ) ); ?>">
                                    <time datetime="<?php comment_time( 'c' ); ?>">
                                        <?php printf( esc_html__( '%1$s at %2$s', 'getbowtied' ), get_comment_date(), get_comment_time() ); ?>
                                    </time>
                                </a>
                            </div><!-- .comment-metadata -->

                        </div>

                        <div class="comment-text"><?php comment_text(); ?>

                            <?php
                                comment_reply_link( array_merge( $args, array(
                                    'add_below' => 'div-comment',
                                    'depth'     => $depth,
                                    'max_depth' => $args['max_depth'],
                                    'before'    => '<span class="comment-reply">&nbsp;&nbsp;',
                                    'after'     => '</span>',
                                ) ) );
                            ?>

                            <?php edit_comment_link( esc_html__( 'Edit', 'getbowtied' ), '<span class="comment-edit-link">', '</span>' ); ?>
                        </div><!-- .comment-text -->


                        <div class="comment-separator"></div>

                </div><!-- .comment-content -->

            </article><!-- .comment-body -->

    <?php
    }

    return;
}

/*
* Header Tool Icons.
*/
function merchandiser_get_header_icons() {
    global $yith_wcwl;

    $search   = Merchandiser_Options::getOption( 'header_search', true );
    $wishlist = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && MERCHANDISER_WISHLIST_IS_ACTIVE && Merchandiser_Options::getOption( 'header_wishlist', true ) );
    $cart     = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && Merchandiser_Options::getOption( 'header_cart', true ) );
    $account  = ( MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && Merchandiser_Options::getOption( 'header_user_account', true ) );

    ?>
    <div class="tools">
        <ul>
            <?php if ( $wishlist ) { ?>
                <li class="wishlist-button">
                    <a class="tools_button" href="<?php echo esc_url($yith_wcwl->get_wishlist_url()); ?>">

                        <?php if ( !empty( Merchandiser_Options::getOption( 'header_wishlist_icon', '' ) ) ) { ?>

                            <?php $ext = explode( '.', Merchandiser_Options::getOption( 'header_wishlist_icon', '' ) ); ?>

                            <?php if (in_array('svg', $ext)): ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <?php echo Merchandiser::get_local_file_contents( Merchandiser_Options::getOption( 'header_wishlist_icon', '' ) ); ?>
                                </span>
                            <?php else: ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <img src="<?php echo esc_url( Merchandiser_Options::getOption( 'header_wishlist_icon', '' ) ); ?>">
                                </span>
                            <?php endif; ?>

                        <?php } else { ?>

                            <span class="tools_button_icon wishlist-icon">
                                <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'>
                                    <path d='M16.5,3C13.605,3,12,5.09,12,5.09S10.395,3,7.5,3C4.462,3,2,5.462,2,8.5c0,4.171,4.912,8.213,6.281,9.49 C9.858,19.46,12,21.35,12,21.35s2.142-1.89,3.719-3.36C17.088,16.713,22,12.671,22,8.5C22,5.462,19.538,3,16.5,3z M14.811,16.11 c-0.177,0.16-0.331,0.299-0.456,0.416c-0.751,0.7-1.639,1.503-2.355,2.145c-0.716-0.642-1.605-1.446-2.355-2.145 c-0.126-0.117-0.28-0.257-0.456-0.416C7.769,14.827,4,11.419,4,8.5C4,6.57,5.57,5,7.5,5c1.827,0,2.886,1.275,2.914,1.308L12,8 l1.586-1.692C13.596,6.295,14.673,5,16.5,5C18.43,5,20,6.57,20,8.5C20,11.419,16.231,14.827,14.811,16.11z'>
                                    </path>
                                </svg>
                            </span>

                        <?php } ?>

                        <span class="wishlist_items_number"><?php echo yith_wcwl_count_products(); ?></span>
                    </a>
                </li>
            <?php } ?>

            <?php if ( $search ) { ?>
                <li class="search-button">
                    <a class="tools_button">
                        <?php if ( !empty( Merchandiser_Options::getOption( 'header_search_icon', '' ) ) ) { ?>

                            <?php $ext = explode( '.', Merchandiser_Options::getOption( 'header_search_icon', '' ) ); ?>

                            <?php if (in_array('svg', $ext)): ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <?php echo Merchandiser::get_local_file_contents( Merchandiser_Options::getOption( 'header_search_icon', '' ) ); ?>
                                </span>
                            <?php else: ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <img src="<?php echo esc_url( Merchandiser_Options::getOption( 'header_search_icon', '' ) ); ?>">
                                </span>
                            <?php endif; ?>

                        <?php } else { ?>

                            <span class="tools_button_icon search-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" width="24" height="24" viewBox="0 0 30 30">
                                    <path d="M 13 3 C 7.4889971 3 3 7.4889971 3 13 C 3 18.511003 7.4889971 23 13 23 C 15.396508 23 17.597385 22.148986 19.322266 20.736328 L 25.292969 26.707031 A 1.0001 1.0001 0 1 0 26.707031 25.292969 L 20.736328 19.322266 C 22.148986 17.597385 23 15.396508 23 13 C 23 7.4889971 18.511003 3 13 3 z M 13 5 C 17.430123 5 21 8.5698774 21 13 C 21 17.430123 17.430123 21 13 21 C 8.5698774 21 5 17.430123 5 13 C 5 8.5698774 8.5698774 5 13 5 z">
                                    </path>
                                </svg>
                            </span>

                        <?php } ?>
                    </a>
                </li>
            <?php } ?>

            <?php if ( $cart ) { ?>
                <li class="shopping-bag-button">
                    <a class="tools_button" href="<?php echo esc_url(wc_get_cart_url()); ?>">

                        <?php if ( !empty( Merchandiser_Options::getOption( 'header_cart_icon', '' ) ) ) { ?>

                            <?php $ext = explode( '.', Merchandiser_Options::getOption( 'header_cart_icon', '' ) ); ?>

                            <?php if (in_array('svg', $ext)): ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <?php echo Merchandiser::get_local_file_contents( Merchandiser_Options::getOption( 'header_cart_icon', '' ) ); ?>
                                </span>
                            <?php else: ?>
                                <span class="tools_button_icon uploaded_icon">
                                    <img src="<?php echo esc_url( Merchandiser_Options::getOption( 'header_cart_icon', '' ) ); ?>">
                                </span>
                            <?php endif; ?>

                        <?php } else { ?>

                            <span class="tools_button_icon shopping-cart-icon">
                                <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'>
                                    <path d='M 4.4140625 1.9960938 L 1.0039062 2.0136719 L 1.0136719 4.0136719 L 3.0839844 4.0039062 L 6.3789062 11.908203 L 5.1816406 13.824219 C 4.7816406 14.464219 4.7609531 15.272641 5.1269531 15.931641 C 5.4929531 16.590641 6.1874063 17 6.9414062 17 L 19 17 L 19 15 L 6.9414062 15 L 6.8769531 14.882812 L 8.0527344 13 L 15.521484 13 C 16.248484 13 16.917531 12.604703 17.269531 11.970703 L 20.873047 5.4863281 C 21.046047 5.1763281 21.041328 4.7981875 20.861328 4.4921875 C 20.681328 4.1871875 20.352047 4 19.998047 4 L 5.25 4 L 4.4140625 1.9960938 z M 6.0820312 6 L 18.298828 6 L 15.521484 11 L 8.1660156 11 L 6.0820312 6 z M 7 18 A 2 2 0 0 0 5 20 A 2 2 0 0 0 7 22 A 2 2 0 0 0 9 20 A 2 2 0 0 0 7 18 z M 17 18 A 2 2 0 0 0 15 20 A 2 2 0 0 0 17 22 A 2 2 0 0 0 19 20 A 2 2 0 0 0 17 18 z'>
                                    </path>
                                </svg>
                            </span>

                        <?php } ?>

                        <span class="shopping_bag_items_number"><?php echo esc_html(WC()->cart->get_cart_contents_count()); ?></span>
                    </a>
                </li>
            <?php } ?>

            <?php if ( $account ) { ?>

                <li class="my-account-button">

                    <?php if ( is_user_logged_in() ) { ?>
                        <div class="myaccount-dropdown">
                            <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" class="tools_button">
                                <?php if ( !empty( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ) ) { ?>

                                    <?php $ext = explode( '.', Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>

                                    <?php if (in_array('svg', $ext)): ?>
                                        <span class="tools_button_icon uploaded_icon">
                                            <?php echo Merchandiser::get_local_file_contents( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="tools_button_icon uploaded_icon">
                                            <img src="<?php echo esc_url( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>">
                                        </span>
                                    <?php endif; ?>

                                <?php } else { ?>

                                    <span class="tools_button_icon account-icon">
                                        <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'>
                                            <path d='M 12 3 C 9.8027056 3 8 4.8027056 8 7 C 8 9.1972944 9.8027056 11 12 11 C 14.197294 11 16 9.1972944 16 7 C 16 4.8027056 14.197294 3 12 3 z M 12 5 C 13.116414 5 14 5.8835859 14 7 C 14 8.1164141 13.116414 9 12 9 C 10.883586 9 10 8.1164141 10 7 C 10 5.8835859 10.883586 5 12 5 z M 12 14 C 10.255047 14 8.1871638 14.409783 6.4492188 15.095703 C 5.5802462 15.438663 4.7946961 15.84605 4.1660156 16.369141 C 3.5373351 16.892231 3 17.599384 3 18.5 L 3 21 L 21 21 L 21 20 L 21 18.5 C 21 17.599384 20.462665 16.892231 19.833984 16.369141 C 19.205304 15.84605 18.419754 15.438663 17.550781 15.095703 C 15.812836 14.409783 13.744953 14 12 14 z M 12 16 C 13.414047 16 15.346055 16.373999 16.818359 16.955078 C 17.554512 17.245618 18.176961 17.591965 18.554688 17.90625 C 18.932412 18.220535 19 18.434616 19 18.5 L 19 19 L 5 19 L 5 18.5 C 5 18.434616 5.0675867 18.220535 5.4453125 17.90625 C 5.8230383 17.591965 6.4454882 17.245618 7.1816406 16.955078 C 8.6539455 16.373999 10.585953 16 12 16 z'>
                                            </path>
                                        </svg>
                                    </span>

                                <?php } ?>
                            </a>

                            <ul>
                                <li class="avatar">
                                <?php
                                    $id = get_current_user_id( );
                                    echo get_avatar($id, '40');
                                ?>
                                </li>

                                <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'my-account',
                                    'fallback_cb'    => false,
                                    'container'      => false,
                                    'items_wrap'     => '%3$s'
                                ));
                                ?>

                                <li>
                                    <a href="<?php echo wp_logout_url( home_url() ); ?>" class="logout">
                                        <svg
                                            xmlns="http://www.w3.org/2000/svg" x="0px" y="0px"
                                            width="16" height="16"
                                            viewBox="0 0 24 24">
                                            <path d="M 11 2 L 11 12 L 13 12 L 13 2 L 11 2 z M 9 2.4589844 C 4.943 3.7339844 2 7.523 2 12 C 2 17.523 6.477 22 12 22 C 17.523 22 22 17.523 22 12 C 22 7.523 19.057 3.7339844 15 2.4589844 L 15 4.5878906 C 17.931 5.7748906 20 8.644 20 12 C 20 16.418 16.418 20 12 20 C 7.582 20 4 16.418 4 12 C 4 8.643 6.069 5.7748906 9 4.5878906 L 9 2.4589844 z"></path>
                                        </svg>
                                        <?php esc_html_e('Logout', 'woocommerce'); ?>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    <?php } else { ?>
                        <a class="tools_button my-account-login-button" href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>">
                            <?php if ( !empty( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ) ) { ?>

                                <?php $ext = explode( '.', Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>

                                <?php if (in_array('svg', $ext)): ?>
                                    <span class="tools_button_icon uploaded_icon">
                                        <?php echo Merchandiser::get_local_file_contents( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>
                                    </span>
                                <?php else: ?>
                                    <span class="tools_button_icon uploaded_icon">
                                        <img src="<?php echo esc_url( Merchandiser_Options::getOption( 'header_user_account_icon', '' ) ); ?>">
                                    </span>
                                <?php endif; ?>

                            <?php } else { ?>

                                <span class="tools_button_icon account-icon">
                                    <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'>
                                        <path d='M 12 3 C 9.8027056 3 8 4.8027056 8 7 C 8 9.1972944 9.8027056 11 12 11 C 14.197294 11 16 9.1972944 16 7 C 16 4.8027056 14.197294 3 12 3 z M 12 5 C 13.116414 5 14 5.8835859 14 7 C 14 8.1164141 13.116414 9 12 9 C 10.883586 9 10 8.1164141 10 7 C 10 5.8835859 10.883586 5 12 5 z M 12 14 C 10.255047 14 8.1871638 14.409783 6.4492188 15.095703 C 5.5802462 15.438663 4.7946961 15.84605 4.1660156 16.369141 C 3.5373351 16.892231 3 17.599384 3 18.5 L 3 21 L 21 21 L 21 20 L 21 18.5 C 21 17.599384 20.462665 16.892231 19.833984 16.369141 C 19.205304 15.84605 18.419754 15.438663 17.550781 15.095703 C 15.812836 14.409783 13.744953 14 12 14 z M 12 16 C 13.414047 16 15.346055 16.373999 16.818359 16.955078 C 17.554512 17.245618 18.176961 17.591965 18.554688 17.90625 C 18.932412 18.220535 19 18.434616 19 18.5 L 19 19 L 5 19 L 5 18.5 C 5 18.434616 5.0675867 18.220535 5.4453125 17.90625 C 5.8230383 17.591965 6.4454882 17.245618 7.1816406 16.955078 C 8.6539455 16.373999 10.585953 16 12 16 z'>
                                        </path>
                                    </svg>
                                </span>

                            <?php } ?>
                        </a>
                    <?php } ?>
                </li>
            <?php } ?>
        </ul>
    </div>
    <?php
}

/*
* Header Site Identity.
*/
function merchandiser_get_header_identity() {
    $default_header_logo    = Merchandiser_Options::getOption( 'header_alt_logo', '' );
    $custom_header_logo     = merchandiser_get_header_logo('default');
    $custom_header_alt_logo = merchandiser_get_header_logo('alt');

    $transparent_header = Merchandiser_Options::getOption( 'header_transparent', false );
    if ( !MERCHANDISER_WOOCOMMERCE_IS_ACTIVE || !is_product_category() ) {
        $transparent_header = get_post_meta( Merchandiser::get_page_id(), 'page_header_transparency', true );
    }
    if (MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && is_product_category()) {
        if( 'no_transparency' === Merchandiser_Options::getOption( 'category_transparency', 'inherit' ) ) {
            $transparent_header = false;
        } elseif( 'inherit' != Merchandiser_Options::getOption( 'category_transparency', 'inherit' ) ) {
            $transparent_header = true;
        }
    }

    ?>
    <div class="site-branding">

        <?php if ( ! empty( $custom_header_logo ) ) { ?>

            <?php $transparent_logo = Merchandiser_Options::getOption( 'header_transparent_sticky_default_logo', false ) && $transparent_header && ( $default_header_logo != $custom_header_logo ); ?>

            <div class="site-logo <?php echo empty( $custom_header_alt_logo ) ? esc_html('mobile') : esc_html(''); ?> <?php echo esc_html($transparent_logo) ? esc_html('') : esc_html('transparent-sticky-logo'); ?>">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <img src="<?php echo esc_url( $custom_header_logo ); ?>" alt="<?php echo bloginfo('name'); ?>">
                </a>
            </div>

            <?php if( $transparent_logo ) { ?>
                <?php
                if( empty( $default_header_logo ) ) {
                    $default_header_logo = $custom_header_logo;
                }
                ?>
                <div class="site-logo transparent-sticky-logo">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                        <img src="<?php echo esc_url( $default_header_logo ); ?>" alt="<?php echo bloginfo('name'); ?>">
                    </a>
                </div>
            <?php } ?>

            <?php if ( ! empty( $custom_header_alt_logo ) ): ?>
                <div class="mobile-site-logo">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home" class="alt-header-logo">
                        <img src="<?php echo esc_url( $custom_header_alt_logo ); ?>" alt="<?php echo bloginfo('name'); ?>">
                    </a>
                </div>
            <?php endif; ?>

        <?php } else { ?>

            <div class="site-title">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    <?php bloginfo( 'name' ); ?>
                </a>
            </div>

        <?php } ?>

    </div>
    <?php
}

/*
* Header Logo.
*/
function merchandiser_get_header_logo( $logo = 'default' ) {

    if( 'alt' === $logo ) {
        // preserve original logo in case we need to switch back to it
        $custom_header_alt_logo = Merchandiser_Options::getOption( 'header_alt_logo', '' );
        if (is_ssl()) {
            $custom_header_alt_logo = str_replace( "http://", "https://", $custom_header_alt_logo );
        }

        return $custom_header_alt_logo;
    }

    // preserve original logo in case we need to switch back to it
    $custom_header_logo = $original_logo =  Merchandiser_Options::getOption( 'header_logo', '' );

    //Header Transparency Logo
    if ( Merchandiser_Options::getOption( 'header_transparent', false ) ) {
        if ( 'light' === Merchandiser_Options::getOption( 'header_transparent_scheme', 'dark' ) ) {
            $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_light_logo', '' );
        } else {
            $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_dark_logo', '' );
        }
    }

    if (MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && is_product_category()) {
        switch ( Merchandiser_Options::getOption( 'category_transparency', 'transparency_light' ) ) {
            case 'inherit':
                // Do nothing
                break;

            case 'no_transparency':
                $custom_header_logo = $original_logo;
                break;

            case 'transparency_light':
                $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_light_logo', '' );
                break;

            case 'transparency_dark':
                $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_dark_logo', '' );
                break;
        }
    }

    $page_header_transparency = get_post_meta( Merchandiser::get_page_id(), 'page_header_transparency', true );

    switch ( $page_header_transparency ) {
        case "inherit":
            // do nothing
            break;
        case "transparency_light":
            $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_light_logo', '' );
            break;
        case "transparency_dark":
            $custom_header_logo = Merchandiser_Options::getOption( 'header_transparent_dark_logo', '' );
            break;
        case "no_transparency":
            $custom_header_logo = $original_logo;
            break;
        default:

            break;
    }

    if (is_ssl()) {
        $custom_header_logo = str_replace( "http://", "https://", $custom_header_logo );
    }

    return $custom_header_logo;
}

/*
* Header Navigation.
*/
function merchandiser_get_header_navigation() {
    $header_navigation_alignment = ( 'header_1' === Merchandiser_Options::getOption( 'header_layout', 'header_2' ) ) ? Merchandiser_Options::getOption( 'header_navigation_alignment', 'left' ) : 'align_left';
    ?>
    <div class="nav">

        <ul class="menu-mobile-navigation">
            <li class="menu-item menu-button">
                <span class="tools_button">
                    <svg xmlns='http://www.w3.org/2000/svg' width='24' height='24' viewBox='0 0 24 24'>
                        <path d='M 2 5 L 2 7 L 22 7 L 22 5 L 2 5 z M 2 11 L 2 13 L 22 13 L 22 11 L 2 11 z M 2 17 L 2 19 L 22 19 L 22 17 L 2 17 z'>
                        </path>
                    </svg>
                </span>
            </li>
        </ul>

        <?php if ( 'flyout' === Merchandiser_Options::getOption( 'header_navigation_style', 'slices' ) ) { ?>

            <nav class="main-navigation-flyout <?php echo ent2ncr($header_navigation_alignment); ?>" >
                <?php

                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'fallback_cb'    => false,
                    'container'      => false,
                    'items_wrap'     => '<ul class="%1$s">%3$s</ul>'
                ));

                ?>
            </nav>

        <?php } elseif ( 'slices' === Merchandiser_Options::getOption( 'header_navigation_style', 'slices' ) ) { ?>

            <nav class="main-navigation-slices" >
                <?php

                $args = array(
                    'theme_location' => 'primary',
                    'fallback_cb'    => false,
                    'container'      => false,
                    'items_wrap'     => '<ul class="%1$s">%3$s</ul>'
                );

                if ( class_exists('Merchandiser_Nav_Menu_Output')) {
                    $walker = new Merchandiser_Nav_Menu_Output;
                    $args['walker'] = $walker;
                }

                wp_nav_menu($args);

                ?>
            </nav>

        <?php } ?>
    </div>
    <?php
}
