<?php
if (get_post_meta( Merchandiser::get_page_id(), 'page_title_meta_box_check', true )) {
    $page_title_option = get_post_meta( Merchandiser::get_page_id(), 'page_title_meta_box_check', true );
} else {
    $page_title_option = "on";
}
?>

<?php if ( is_search() && !have_posts() ) : ?>

	<?php get_template_part( 'content', 'none' ); ?>

<?php else : ?>

	<div class="blog_layout_1">

		<div class="row" style="max-width: 100%">


			<div id="primary" class="content-area fullwidth">

				<main id="main" class="site-main">

			    	<?php if ( "on" == $page_title_option ) : ?>

						<div class="blog-header-wrapper">
							<h1 class="blog-header page-title"><?php wp_title( '' ); ?> </h1>

							<?php if ('' != category_description()) : ?>
								<div class="blog-category-description">
									<?php echo category_description(); ?>
								</div>
							<?php endif; ?>
						</div>

					<?php endif; ?>

					<div class="blog_categories_list">
						<div class="blog_categories_list_overlay"></div>
						<ul class="blog_categories_list">
							<li class="cat-item <?php echo is_home()? 'current-cat' : ''; ?>">
								<a href="<?php if( get_option( 'show_on_front' ) == 'page' ) echo get_permalink( get_option('page_for_posts' ) );
									else echo esc_url( home_url() );?>"><?php echo esc_html__( 'ALL', 'getbowtied'); ?>
								</a>
							</li>
						   <?php

						   $args = array(
							   'show_option_all'    => '',
							   'orderby'            => 'name',
							   'order'              => 'ASC',
							   'style'              => 'list',
							   'show_count'         => 0,
							   'hide_empty'         => 1,
							   'use_desc_for_title' => 1,
							   'child_of'           => 0,
							   'feed'               => '',
							   'feed_type'          => '',
							   'feed_image'         => '',
							   'exclude'            => '',
							   'exclude_tree'       => '',
							   'include'            => '',
							   'hierarchical'       => 1,
							   'title_li'           => '',
							   'show_option_none'   => 'No categories',
							   'number'             => null,
							   'echo'               => 1,
							   'depth'              => 1,
							   'current_category'   => 0,
							   'pad_counts'         => 0,
							   'taxonomy'           => 'category',
							   'walker'             => null
					   		);

							wp_list_categories( $args ); ?>
						</ul>
					</div>

					<ul class="blog_posts">


						<?php if ( have_posts() ) : ?>

						<?php while ( have_posts() ) : the_post(); ?>

								<li class="blog_post">

									<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

                                        <?php if( is_sticky() ) { ?>
                                            <div class="sticky-star">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 26 26">
                                                    <path d="M12,18.091l4.969,2.999c0.784,0.473,1.751-0.23,1.543-1.121l-1.319-5.653l4.391-3.804c0.692-0.599,0.322-1.736-0.59-1.813 l-5.78-0.49l-2.261-5.335c-0.357-0.841-1.549-0.841-1.906,0L8.786,8.209l-5.78,0.49c-0.912,0.077-1.282,1.214-0.59,1.813 l4.391,3.804l-1.319,5.653c-0.208,0.891,0.759,1.594,1.543,1.121L12,18.091z"/>
                                                </svg>
                                            </div>
                                        <?php } ?>

										<?php if ( has_post_thumbnail() ) { ?>
											<a href="<?php echo esc_url( get_permalink() ); ?>" rel="bookmark">
												<div class="image-wrapper">
													<img class="attachment-post-thumbnail size-post-thumbnail wp-post-image" src="<?php echo esc_url( the_post_thumbnail_url( 'full' ) ); ?>" alt="post-image" />
												</div>
											</a>
										<?php } ?>

										<div class="post_content_wrapper">

											<div class="post_content">

												<?php the_category(); ?>

										        <?php the_title( sprintf( '<h3 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' ); ?>

										        <?php the_excerpt(); ?>

										        <a class="read_more" href="<?php echo get_permalink(); ?>"> <?php echo esc_html_e( 'Read more', 'getbowtied' ); ?></a>

									        </div>

										</div>

										<a class="entry-link" href="<?php echo the_permalink(); ?>"></a>

									</article>

								</li>

						<?php endwhile; ?>

					<?php else : ?>

						<?php get_template_part( 'content', 'none' ); ?>

					<?php endif; ?>

					</ul>

                    <nav class="posts-navigation" >
                        <div class="nav-links">
                            <?php

                            echo paginate_links( array(
                                'prev_next' => true,
                                'prev_text' => '',
                                'next_text' => '',
                            ) );

                            ?>
                        </div>
                    </nav>

				</main> <!--  end main -->

			</div>  <!--  end primary -->

		</div>  <!--  end full row -->

	</div>  <!-- end blog layout 1 -->
<?php endif; ?>
