<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Check if the product is a valid WooCommerce product and ensure its visibility before proceeding.
if ( ! is_a( $product, WC_Product::class ) || ! $product->is_visible() ) {
	return;
}

remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5 );
remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10 );
remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10 );

add_action( 'woocommerce_before_shop_loop_item_thumbnail', 'merchandiser_product_badges', 15 );

add_action( 'woocommerce_before_shop_loop_item_thumbnail', 'woocommerce_template_loop_product_link_open', 5 );
add_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 15 );

add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_open', 5 );
add_action( 'woocommerce_shop_loop_item_title', 'woocommerce_template_loop_product_link_close', 15 );

add_action( 'woocommerce_shop_loop_item_buttons', 'woocommerce_template_loop_add_to_cart', 10 );

if ( Merchandiser_Options::getOption( 'shop_quick_view', true ) ) {
	add_action( 'woocommerce_shop_loop_item_buttons', 'merchandiser_product_quick_view_button', 5 );
}

if ( MERCHANDISER_WISHLIST_IS_ACTIVE ) {
	add_action( 'woocommerce_shop_loop_item_buttons', 'merchandiser_product_wishlist_button', 6 );
}

// Second Image
$style = '';
$class = '';
if( Merchandiser_Options::getOption( 'shop_second_image', true ) ) {
    $attachment_ids = $product->get_gallery_image_ids();
    if ( $attachment_ids && isset($attachment_ids[0]) ) {
        $product_thumbnail_second = wp_get_attachment_image_src($attachment_ids[0], 'woocommerce_thumbnail');
    }
    if( isset($product_thumbnail_second[0]) ) {
        $style = 'background-image:url(' . $product_thumbnail_second[0] . ')';
        $class = 'with_second_image';
    }
}

$product_class = Merchandiser_Options::getOption( 'shop_hover_shadow', true ) ? 'with-shadow' : '';

?>

<li <?php wc_product_class( $product_class, $product ); ?>>

    <?php
    /**
     * Hook: woocommerce_before_shop_loop_item.
     */
    do_action( 'woocommerce_before_shop_loop_item' );
    ?>

    <div class="product_thumbnail <?php echo esc_attr($class); ?>">

        <?php
        /**
         * Hook: woocommerce_before_shop_loop_item_thumbnail.
         *
         * @hooked woocommerce_template_loop_product_link_open - 5
		 * @hooked merchandiser_product_badges - 15
         */
        do_action( 'woocommerce_before_shop_loop_item_thumbnail' );
        ?>

        <?php if ( Merchandiser_Options::getOption( 'shop_second_image', true ) ) { ?>
            <span class="product_thumbnail_secondary" style="<?php echo ent2ncr($style); ?>"></span>
        <?php } ?>

        <?php
        /**
         * Hook: woocommerce_before_shop_loop_item_title.
         *
         * @hooked woocommerce_template_loop_product_thumbnail - 10
         * @hooked woocommerce_template_loop_product_link_close - 15
         */
        do_action( 'woocommerce_before_shop_loop_item_title' );
        ?>

        <?php if (!Merchandiser_Options::getOption( 'catalog_mode', false ) || Merchandiser_Options::getOption( 'shop_quick_view', true ) ) { ?>
            <div class="shop_product_buttons_wrapper">
                <div class="shop_product_buttons">
                    <?php
                    /**
                     * Hook: woocommerce_shop_loop_item_buttons.
                     *
                     * @hooked merchandiser_product_quick_view_button - 5
                     * @hooked woocommerce_template_loop_add_to_cart - 10
                     */
                    do_action( 'woocommerce_shop_loop_item_buttons' );
                    ?>
                </div>
            </div>
        <?php } ?>
    </div>

    <?php if ( Merchandiser_Options::getOption( 'shop_product_details', true ) ) { ?>

        <div class="shop_product_metas">

            <?php
            /**
        	 * Hook: woocommerce_shop_loop_item_title.
        	 *
        	 * @hooked woocommerce_template_loop_product_title - 10
        	 */
        	do_action( 'woocommerce_shop_loop_item_title' );

            /**
        	 * Hook: woocommerce_after_shop_loop_item_title.
        	 *
        	 * @hooked woocommerce_template_loop_rating - 5
             * @hooked woocommerce_show_product_loop_sale_flash - 7
        	 * @hooked woocommerce_template_loop_price - 10
        	 */
        	do_action( 'woocommerce_after_shop_loop_item_title' );
            ?>

        </div>

    <?php } ?>

    <?php
    /**
	 * Hook: woocommerce_after_shop_loop_item.
	 *
	 */
	do_action( 'woocommerce_after_shop_loop_item' );
    ?>

</li>
