<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10);
remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_upsell_display', 15 );
remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

add_action( 'woocommerce_single_product_summary_info', 'woocommerce_template_single_price', 20 );
add_action( 'woocommerce_single_product_summary_info', 'woocommerce_template_single_rating', 30 );
add_action( 'woocommerce_single_product_summary', 'merchandiser_out_of_stock_badge', 25 );
add_action( 'woocommerce_single_product_summary_single_meta', 'woocommerce_template_single_meta', 10 );
add_action( 'woocommerce_single_product_summary_single_sharing', 'woocommerce_template_single_sharing', 10 );
add_action( 'woocommerce_after_single_product_summary_data_tabs', 'woocommerce_output_product_data_tabs', 10 );
add_action( 'woocommerce_single_product_summary_title', 'woocommerce_breadcrumb', 20 );
add_action( 'woocommerce_single_product_summary_title', 'woocommerce_template_single_title', 30 );
add_action( 'woocommerce_single_product_summary_title', 'woocommerce_show_product_sale_flash', 40 );
add_action( 'woocommerce_after_single_product_summary_upsells', 'merchandiser_output_upsells', 15 );
add_action( 'woocommerce_after_single_product_summary_related', 'merchandiser_output_related', 20 );

global $product;

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );
?>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( '', $product ); ?>>

    <div class="product_content_wrapper <?php echo ( 'classic' === Merchandiser_Options::getOption( 'product_image_gallery', 'half_page' ) ) ? 'layout_classic' : 'layout_half'; ?>">

		<div class="product_wrapper">

			<div class="product-gallery-wrapper">
				<?php
				/**
				 * Hook: woocommerce_before_single_product_summary.
				 *
				 * @hooked woocommerce_show_product_images - 20
				 */
				do_action( 'woocommerce_before_single_product_summary' );
				?>
				<div class="product-image-temp">
					<img src="<?php echo wp_get_attachment_image_url( get_post_thumbnail_id( get_the_ID() ), 'full' ); ?>" alt="temp-image"/>
				</div>
			</div>

	        <div class="product_infos summary entry-summary">

                <?php
                /**
                 * Hook: woocommerce_single_product_summary_title.
                 *
                 * @hooked woocommerce_breadcrumb - 20
                 * @hooked woocommerce_template_single_title - 30
				 * @hooked woocommerce_show_product_sale_flash - 40
                 */
                do_action( 'woocommerce_single_product_summary_title' );
                ?>

                <div class="after_title_wrapper">
                    <?php
                    /**
                     * Hook: woocommerce_single_product_summary_info.
                     *
                     * @hooked woocommerce_template_single_price - 20
                     * @hooked woocommerce_template_single_rating - 30
                     */
                    do_action( 'woocommerce_single_product_summary_info' );
                    ?>
                </div>

                <?php
                /**
        		 * Hook: woocommerce_single_product_summary.
        		 *
        		 * @hooked woocommerce_template_single_excerpt - 20
                 * @hooked merchandiser_out_of_stock_badge - 25
        		 * @hooked woocommerce_template_single_add_to_cart - 30
        		 * @hooked WC_Structured_Data::generate_product_data() - 60
        		 */
                do_action( 'woocommerce_single_product_summary' );
                ?>

                <div class="after_single_product_summary">

                    <div class="product_meta_wrapper">
                        <?php
                        /**
                		 * Hook: woocommerce_single_product_summary_single_meta.
                		 *
                		 * @hooked woocommerce_template_single_meta - 10
                		 */
                        do_action( 'woocommerce_single_product_summary_single_meta' );
                        ?>
                    </div>

                    <div class="single_product_share_wrapper">
                        <?php
                        /**
                		 * Hook: woocommerce_single_product_summary_single_sharing.
                		 *
                		 * @hooked woocommerce_template_single_sharing - 10
                		 */
                        do_action( 'woocommerce_single_product_summary_single_sharing' );
                        ?>
                    </div>

                </div>

                <?php
                /**
            	 * Hook: woocommerce_after_single_product_summary.
            	 */
                do_action( 'woocommerce_after_single_product_summary' );
                ?>

                <meta itemprop="url" content="<?php the_permalink(); ?>" />

            </div>

			<div class="clear"></div>
		</div>

        <div class="woocommerce_tabs_wrapper">
            <div class="row">
                <div class="large-12 large-centered columns">
                    <?php
                    /**
                     * Hook: woocommerce_after_single_product_summary_data_tabs.
                     *
                     * @hooked woocommerce_output_product_data_tabs - 10
                     */
                    do_action( 'woocommerce_after_single_product_summary_data_tabs' );
                    ?>
                </div>
            </div>
        </div>

        <?php
		/**
		 * woocommerce_after_single_product_summary_upsells hook.
		 *
		 * @hooked getbowtied_output_upsells - 15
		 */
		do_action('woocommerce_after_single_product_summary_upsells');

		if ( Merchandiser_Options::getOption( 'related_products', true ) ) {
			/**
			 * woocommerce_after_single_product_summary_related hook.
			 *
			 * @hooked getbowtied_output_related - 20
			 */
			do_action('woocommerce_after_single_product_summary_related');
		}
        ?>

    </div>

</div>

<?php do_action( 'woocommerce_after_single_product' ); ?>
