<?php
/**
 * Product Loop Start
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

global $woocommerce_loop;

if ( ( isset($woocommerce_loop['columns']) && !empty($woocommerce_loop['columns']) ) ) {
	$products_per_column = $woocommerce_loop['columns'];
} else {
	$products_per_column = get_option('woocommerce_catalog_columns', 4);

	if (isset($_GET["products_per_row"])) {
		$products_per_column = $_GET["products_per_row"];
	}
}

if ( 'regular' === Merchandiser_Options::getOption( 'shop_layout_style', 'regular' ) || ( !is_shop() && !is_product_category() ) ) {

	switch( $products_per_column ) {
	    case 6:
	        $products_per_column_xlarge = 6;
	    	$products_per_column_large 	= 6;
	    	$products_per_column_medium = 3;
	    	$products_per_column_small 	= 2;
	        break;
	    case 5:
	        $products_per_column_xlarge = 5;
	        $products_per_column_large 	= 5;
	        $products_per_column_medium = 3;
	        $products_per_column_small 	= 2;
	        break;
	    case 4:
	        $products_per_column_xlarge = 4;
	        $products_per_column_large 	= 4;
	        $products_per_column_medium = 3;
	        $products_per_column_small 	= 2;
	        break;
	    case 3:
	        $products_per_column_xlarge = 3;
	        $products_per_column_large 	= 3;
	        $products_per_column_medium = 3;
	        $products_per_column_small 	= 2;
	        break;
	    case 2:
	        $products_per_column_xlarge = 2;
	        $products_per_column_large 	= 2;
	        $products_per_column_medium = 2;
	        $products_per_column_small 	= 2;
	        break;
	    case 1:
	        $products_per_column_xlarge = 1;
	        $products_per_column_large 	= 1;
	        $products_per_column_medium = 1;
	        $products_per_column_small 	= 1;
	        break;
	    default:
	        $products_per_column_xlarge = 6;
	        $products_per_column_large 	= 6;
	        $products_per_column_medium = 3;
	        $products_per_column_small 	= 2;
	        break;
	}

	?>

	<ul

	class="	products products-grid
			small-block-grid-<?php   echo esc_attr($products_per_column_small); 	?>
			medium-block-grid-<?php  echo esc_attr($products_per_column_medium); 	?>
			large-block-grid-<?php 	 echo esc_attr($products_per_column_large); 	?>
			xlarge-block-grid-<?php  echo esc_attr($products_per_column_xlarge); 	?>
			xxlarge-block-grid-<?php echo esc_attr($products_per_column);			?>
			columns-<?php 			 echo esc_attr($products_per_column);			?>
	">

<?php

} else {

	?>

	<ul id="masonry_grid" class="products masonry_columns_<?php echo esc_attr($products_per_column); ?>" data-type="products" data-columns>

	<?php
}
