jQuery(function($) {

	"use strict";

	function adjust_header_height() {
		var height = $('.site-header').height();
		$('.site-content').css('padding-top', height + 'px');
		$('body.header-transparent.tax-product_cat .woocommerce-products-header:not(.with-image)').css('margin-top', height + 'px');
	}

	window.header_sticky_scroll = function() {
		if (Foundation.utils.is_large_up()) {
			if ($(document).scrollTop() > 0) {
				$('body.header-transparent.header-sticky').addClass("header-sticky-scroll");
			} else {
				$('body.header-transparent.header-sticky').not(".no-transparency-lock").removeClass("header-sticky-scroll");
			}
		} else {
			$('body.header-transparent.header-sticky').addClass("header-sticky-scroll");
		}
	}

	window.header_sticky_scroll();
	adjust_header_height();

	$(window).on( 'resize', function() {

		window.header_sticky_scroll();
		adjust_header_height();

	});

	$(window).on( 'scroll', function() {

		window.header_sticky_scroll();

		if( $(window).width() <= 600 ) {

			if ($(document).scrollTop() > 0) {
				$('body.admin-bar.header-sticky .site-header').css('top', '0');
			} else {
				$('body.admin-bar.header-sticky .site-header').css('top', '46px');
			}
		} else {
			$('body.admin-bar.header-sticky .site-header').css('top', '');
		}
	});

	$('.offcanvas_aside nav.offcanvas_navigation ul.offcanvas_menu > li.menu-item.menu-item-has-children .sub-menu-icon').on( 'click', function(e) {
		$(this).siblings('.sub-menu').toggleClass('open');
		$(this).siblings('.sub-menu').find('.sub-menu').toggleClass('open');
	});

})
