jQuery(function($) {

	"use strict";

    $.fn.attachDragger = function() {
        var attachment = false, lastPosition, position, difference;
        $( $(this).selector ).on("mousedown mouseup mousemove",function(e){
            if( e.type == "mousedown" ) attachment = true, lastPosition = [e.clientX, e.clientY];
            if( e.type == "mouseup" ) attachment = false;
            if( e.type == "mousemove" && attachment == true ){
                position = [e.clientX, e.clientY];
                difference = [ (position[0]-lastPosition[0]), (position[1]-lastPosition[1]) ];
                $(this).scrollLeft( $(this).scrollLeft() - difference[0] );
                $(this).scrollTop( $(this).scrollTop() - difference[1] );
                lastPosition = [e.clientX, e.clientY];
            }
        });
        $(window).on("mouseup", function(){
            attachment = false;
        });
    }

    if( $(window).width() < 1024 ) {
        $("ul.shop_categories_list").attachDragger();
		$("ul.blog_categories_list").attachDragger();
		$(".woocommerce-MyAccount-navigation > ul").attachDragger();
    }

    $(window).on( 'resize', function() {
        if( $(window).width() < 1024 ) {
            $("ul.shop_categories_list").attachDragger();
			$("ul.blog_categories_list").attachDragger();
			$(".woocommerce-MyAccount-navigation > ul").attachDragger();
        }
    });

	$('.woocommerce-MyAccount-navigation').prepend('<div class="account_navigation_list_overlay"></div>');

	$('.shop_categories_list_overlay').on( 'click', function() {
		$('ul.shop_categories_list').animate({
	        scrollLeft: $('ul.shop_categories_list').scrollLeft() + 100
    	}, 300);
	});

	$('.blog_categories_list_overlay').on( 'click', function() {
		$('ul.blog_categories_list').animate({
	        scrollLeft: $('ul.blog_categories_list').scrollLeft() + 100
    	}, 300);
	});

	$('.account_navigation_list_overlay').on( 'click', function() {
		$('.woocommerce-MyAccount-navigation > ul').animate({
	        scrollLeft: $('.woocommerce-MyAccount-navigation > ul').scrollLeft() + 100
    	}, 300);
	});

});
