jQuery(function($) {

	"use strict";

	function gbt_cn_onElementInserted(containerSelector, selector) {
		if ("MutationObserver" in window) {
			var onMutationsObserved = function (mutations) {
				mutations.forEach(function (mutation) {
					if (mutation.addedNodes.length) {
						if ($(mutation.addedNodes).length) {
							var finalSelector = selector;
							var ownElement = $(mutation.addedNodes).filter(selector);
							ownElement.each(function (index) {
								notif_add_close_button($(this));
							});
							if (!ownElement.length) {
								var childElements = $(mutation.addedNodes).find(finalSelector);
								childElements.each(function (index) {
									notif_add_close_button($(this));
								});
							}
						}
					}
				});
			};

			var target = $(containerSelector)[0];
			var config = {childList: true, subtree: true};
			var MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
			var observer = new MutationObserver(onMutationsObserved);
			observer.observe(target, config);
		}
	}

	gbt_cn_onElementInserted( 'body', '.woocommerce-error' );
	gbt_cn_onElementInserted( 'body', '.woocommerce-message' );
	gbt_cn_onElementInserted( 'body', '.woocommerce-info' );
	gbt_cn_onElementInserted( 'body', '.woocommerce-notice' );

	checkExistingElements('.woocommerce-error');
	checkExistingElements('.woocommerce-message');
	checkExistingElements('.woocommerce-info');
	checkExistingElements('.woocommerce-notice');

	function checkExistingElements(selector) {
		var element = $(selector);
		if (element.length) {
			element.each(function (index) {
				notif_add_close_button($(this));
			});
		}
	}

	function notif_add_close_button( notification ) {
		if( notification.find('.inner').length <= 0 ) {
			notification.wrapInner('<div class="inner"></div>').append('<span class="close-notification"></span>');
		}

		notification.on( 'click', '.close-notification', function() {
			notification.addClass('inactive');
		});
	}

});
