jQuery(function($) {

	"use strict";

	window.right_offcanvas_open = false;
	window.left_offcanvas_open  = false;

	window.right_offcanvas_wrapper_fn = function() {

		if ( !window.right_offcanvas_open ) {

			if( getbowtied_scripts_vars.transparent_header ) {
				$('body').removeClass('header-transparent');
			}

			$('.site-content-overlay').addClass('visible');
			$('.offcanvas_aside.offcanvas_aside_right').addClass('open');

			window.right_offcanvas_open = true;

		} else {

			if( getbowtied_scripts_vars.transparent_header ) {
				$('body').addClass('header-transparent');
			}

			window.offcanvas_close();
			window.right_offcanvas_open = false;
		}
	}

	window.left_offcanvas_wrapper_fn = function() {

		if ( !window.left_offcanvas_open ) {

			if( getbowtied_scripts_vars.transparent_header ) {
				$('body').removeClass('header-transparent');
			}

			$('.site-content-overlay').addClass('visible');
			$('.offcanvas_aside.offcanvas_aside_left').addClass('open');

			window.left_offcanvas_open = true;

		} else {

			if( getbowtied_scripts_vars.transparent_header ) {
				$('body').addClass('header-transparent');
			}

			window.offcanvas_close();
			window.left_offcanvas_open = false;
		}
	}

	function calculate_offcanvas_top_position() {
		var top_position  = 0;
		var header_height = 0;

		if( $('.site-header').length ) {
			header_height = $('.site-header').outerHeight();
		}

		if( $('body').hasClass('header-sticky') ) {
			top_position = header_height;
			if( $('#wpadminbar').length && ( ( $(window).width() > 600 ) || ( $(document).scrollTop() == 0 ) ) ) {
				top_position = top_position + $('#wpadminbar').outerHeight();
			}
		} else {
			if( $('#wpadminbar').length && ($(document).scrollTop() <= header_height) ) {
				top_position = header_height + $('#wpadminbar').height();
			} else if ( $('#wpadminbar').length && $(window).width() > 600 ) {
				top_position = 0 + $('#wpadminbar').height();
			} else {
				top_position = 0;
			}
		}

		$('.offcanvas_aside').css( 'top', top_position );
		$('.offcanvas_aside').css( 'height', 'calc( 100% - ' + top_position + 'px )' );
	}

	calculate_offcanvas_top_position();

	$(window).on( 'resize', function() {
		calculate_offcanvas_top_position();
	});

	$(window).on( 'scroll', function() {
		calculate_offcanvas_top_position();
	});

	window.offcanvas_close = function() {
		$('.site-content-overlay').removeClass('visible');
		$('body').removeClass('offcanvas_for_cart')
		$('body').removeClass('offcanvas_for_quickview');
		$('.offcanvas_aside_left').removeClass('open');
		$('.offcanvas_aside_right').removeClass('open');
	}

	// Open OffCanvas
	$(".shopping-bag-button").on( 'click', function(e) {
		e.preventDefault();

		if( !window.right_offcanvas_open ) {
			window.close_all_header_dropdowns();

			$("body").addClass("offcanvas_for_cart");

			setTimeout(function() {
				window.right_offcanvas_wrapper_fn();
			}, 200);
		} else {
			window.right_offcanvas_wrapper_fn();
		}		
	});

	if( getbowtied_scripts_vars.open_minicart ) {
		$(document).on("click", ".products .add_to_cart_button.product_type_simple, .add_to_cart_inline .add_to_cart_button.product_type_simple", function(e) {

			window.close_all_header_dropdowns();

			$("body").addClass("offcanvas_for_cart");

			window.right_offcanvas_wrapper_fn();
		});
	}

	$(".shop-page-header .shop-page-title-bar .mobile-sidebar-toggle, .blog-header-wrapper .mobile-sidebar-link").on( 'click', function(e) {

		window.close_all_header_dropdowns();

		$('.offcanvas_aside.offcanvas_aside_left').removeClass('menu-sidebar').addClass('widgets-sidebar');

		window.left_offcanvas_wrapper_fn();
	});

	$(".site-header .nav ul.menu-mobile-navigation li.menu-button span.tools_button").on( 'click', function(e) {

		window.close_all_header_dropdowns();

		$('.offcanvas_aside.offcanvas_aside_left').removeClass('widgets-sidebar').addClass('menu-sidebar');

		window.left_offcanvas_wrapper_fn();
	});

	// Overlay Close Offcanvas
	$('.site-content-overlay, .offcanvas_aside .offcanvas_close').on('click', function(){
		window.offcanvas_close();
	});
});
