jQuery(function($) {

	"use strict";

	function product_quick_view_ajax(id) {

		$.ajax({
			url: getbowtied_scripts_vars.ajax_url,
			data: {
				"action" : "merchandiser_product_quick_view",
				'product_id' : id
			},
			success: function(results) {

				$(".offcanvas_quickview_content").html(results);

				var form_variation = $(".offcanvas_quickview").find('.variations_form');
				var form_variation_select = $(".offcanvas_quickview").find('.variations_form .variations select');

            	form_variation.wc_variation_form();
            	form_variation_select.change();

				if ($('.offcanvas_quickview .woocommerce-product-gallery').length > 0 ) {

					$('.offcanvas_quickview .woocommerce-product-gallery .woocommerce-product-gallery__wrapper').addClass('swiper-wrapper');
					$('.offcanvas_quickview .woocommerce-product-gallery .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image').addClass('swiper-slide');

					var quickviewGallery = new Swiper( '.offcanvas_quickview .woocommerce-product-gallery', {
						autoHeight: true,
						direction: 'horizontal',
						grabCursor: true,
						pagination: {
							el: '.offcanvas_quickview .quickview-navigation-bullets',
							clickable: true,
							renderBullet: function (index, className) {
						        return '<span class="' + className + '">' + (index + 1) + '</span>';
						    }
						},
						navigation: {
						    nextEl: '.offcanvas_quickview .swiper-navigation-next',
						    prevEl: '.offcanvas_quickview .swiper-navigation-prev',
					  	},
					});

					if( quickviewGallery.slides.length <= 1 ) {
						$('.offcanvas_quickview .swiper-wrapper').addClass( "disabled" );
						$('.offcanvas_quickview .quickview-navigation').addClass('disabled');
					}
 				}

            	setTimeout(function() {
		        	$('.loader-icon').removeClass('spinning').addClass('stop_spinning');
		        	$('.overlay-loader').delay(500).fadeOut();
		    	}, 500);

			},
		});
	}

    $('.site-content').on('click', '.merchandiser_product_quick_view_button', function(e) {
        e.preventDefault();

        var product_id  = $(this).data('product_id');

		window.close_all_header_dropdowns();

        $("body").addClass("offcanvas_for_quickview");

        $('.overlay-loader').show();
        $('.loader-icon').removeClass('stop_spinning').addClass('spinning');

		right_offcanvas_open = false;
		window.right_offcanvas_wrapper_fn();

        setTimeout(function() {
        	product_quick_view_ajax(product_id);
    	}, 500);
    });
});
