jQuery(function($) {

	"use strict";

	var grid = document.querySelector('.archive #masonry_grid[data-type="products"]');
	var newVal = shop_layout_select_grid_val( getbowtied_scripts_vars.shop_products_per_row );
	var change_layout = getCookie("change_layout");
    var layout_options = [2,3,4,5,6];

	function shop_layout_select_grid_val( newVal ) {

		if ( ( $(window).width() >= 1024 ) && ( newVal == 1 ) ) {
			newVal = 2;
		}
		if ( ( $(window).width() < 1024 ) && ( newVal > 3 ) ) {
			newVal = 3;
		}
		if ( ( $(window).width() < 640 ) && ( newVal > 2 ) ) {
			newVal = 2;
		}

		$('.shop-display-number').removeClass('selected');
		$('.shop-tools#shop_change_layout .shop-display-number[data-newval="'+newVal+'"]').addClass('selected');

		return newVal;
	}

	function getCookie(cname) {
	    var name = cname + "=";
	    var ca = document.cookie.split(';');
	    for(var i = 0; i <ca.length; i++) {
	        var c = ca[i];
	        while (c.charAt(0)==' ') {
	            c = c.substring(1);
	        }
	        if (c.indexOf(name) == 0) {
	            return c.substring(name.length,c.length);
	        }
	    }
	    return "";
	}

	function shop_layout_change_grid( newVal ) {
		if ($('.archive #masonry_grid[data-type="products"]').length) {

			$('.archive #masonry_grid[data-type="products"]').removeClass();
			$('.archive #masonry_grid[data-type="products"]')
				.addClass('products')
				.addClass('masonry_columns_' + newVal)
				.addClass('visible');
			salvattore.recreateColumns(grid);

		} else {

			$('.archive.woocommerce-page .products-grid')
				.removeClass('small-block-grid-2 medium-block-grid-2 large-block-grid-2 xlarge-block-grid-2 xxlarge-block-grid-2')
				.removeClass('small-block-grid-3 medium-block-grid-3 large-block-grid-3 xlarge-block-grid-3 xxlarge-block-grid-3')
				.removeClass('small-block-grid-4 medium-block-grid-4 large-block-grid-4 xlarge-block-grid-4 xxlarge-block-grid-4')
				.removeClass('small-block-grid-5 medium-block-grid-5 large-block-grid-5 xlarge-block-grid-5 xxlarge-block-grid-5')
				.removeClass('small-block-grid-6 medium-block-grid-6 large-block-grid-6 xlarge-block-grid-6 xxlarge-block-grid-6')
				.addClass('small-block-grid-' + newVal)
				.addClass('medium-block-grid-' + newVal)
				.addClass('large-block-grid-' + newVal)
				.addClass('xlarge-block-grid-' + newVal)
				.addClass('xxlarge-block-grid-' + newVal);
		}
	}

	// Product order - Select2
	if ( typeof $.fn.select2 === 'function' ) {
		$('.woocommerce .shop-page-header .shop-page-title-bar .shop-tools#shop_product_sort form.woocommerce-ordering select').select2({
			minimumResultsForSearch: -1,
			dropdownCssClass: "orderby-dropdown",
			width: 'fit-content',
			dropdownAutoWidth: true,
		});
	}

	// Reset cookie
	$(".shop-tools#shop_change_layout").on('click', '.reset-grid', function() {
		$('.shop-display-number').removeClass('selected');
		document.cookie = "change_layout='';path=/";
		shop_layout_change_grid(getbowtied_scripts_vars.shop_products_per_row);
	});

	// Product Grid
	$(".shop-tools#shop_change_layout").on('click', '.shop-display-number', function() {

		newVal 	= $(this).data('newval');

		$('.shop-display-number').removeClass('selected');
		$(this).addClass('selected');

		document.cookie = "change_layout=" + newVal + ';path=/';

		shop_layout_change_grid(newVal);
	});

    if ( change_layout != '' && layout_options.indexOf(parseInt(change_layout)) >= 0 ) {

		newVal = shop_layout_select_grid_val( change_layout );

		shop_layout_change_grid(change_layout);
    }

	$(window).on( 'resize', function() {
		var resized_val = shop_layout_select_grid_val(newVal);

		if( resized_val != newVal ) {
			newVal = resized_val;
			shop_layout_change_grid(resized_val);
		}
	} );

	// Shop Pagination
	if( $('.woocommerce-pagination ul > li:first-child a').hasClass('prev') ) {
		$('.woocommerce-pagination ul > li:first-child').addClass('prev');
	}

});
