<?php
/*
* Predictive search class
*/
if ( !class_exists( 'Merchandiser_Predictive_Search' ) ) {

    class Merchandiser_Predictive_Search {

        public function __construct() {

            // actions
            add_action( 'wp_ajax_getbowtied_ajax_search_products', array( $this, 'ajax_search_products' ) );
            add_action( 'wp_ajax_nopriv_getbowtied_ajax_search_products', array( $this, 'ajax_search_products' ) );
            add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_styles_scripts' ) );
        }

        public function enqueue_styles_scripts() {
            wp_enqueue_script( 'devbridge-autocomplete', get_template_directory_uri() . '/assets/js/vendor/devbridge-jquery-autocomplete.min.js', 	array('jquery'), '1.4.11',  TRUE );
            wp_enqueue_script( 'getbowtied_wcas_jquery-autocomplete' );
        }

        public function getmicrotime(){
            list($usec, $sec) = explode(" ",microtime());
            return ((float)$usec + (float)$sec);
        }

        /**
        * Perform ajax search products
        */
        public function ajax_search_products() {
            global $woocommerce;
            $time_start         = $this->getmicrotime();
            $transient_enabled  = 'no';
            $transient_duration = 12;

            $search_keyword =  $_REQUEST['query'];

            $ordering_args = $woocommerce->query->get_catalog_ordering_args( 'title', 'asc' );
            $suggestions   = array();

            $transient_name = 'ywcas_' . $search_keyword;
            if ( $transient_enabled == 'no' || false === ( $suggestions = get_transient( $transient_name ) ) ) {
                $args = array(
                    's'                   => apply_filters( 'getbowtied_wcas_ajax_search_products_search_query', $search_keyword ),
                    'post_type'           => 'product',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'orderby'             => '',
                    'order'               => '',
                    'posts_per_page'      => 5,
                    'suppress_filters'    => false,
                    'tax_query' => array(
                        array(
                            'taxonomy' => 'product_visibility',
                            'field'    => 'name',
                            'terms'    => 'exclude-from-catalog',
                            'operator' => 'NOT IN',

                        )
                    )
                );

                if( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {

                    $args['meta_query'] = array(
                        array(
                            'key'     => '_stock_status',
                            'value'   => array( 'search', 'instock' ),
                            'compare' => 'IN'
                        )
                    );
                }

                if ( isset( $_REQUEST['product_cat'] ) ) {
                    $args['tax_query'] = array(
                        'relation' => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'field'    => 'slug',
                            'terms'    => $_REQUEST['product_cat']
                        )
                    );
                }

                $products = get_posts( $args );

                if ( ! empty( $products ) ) {
                    foreach ( $products as $post ) {

                        $product = wc_get_product( $post );

                        if( strpos( strtolower($product->get_title()), strtolower($search_keyword) ) !== false ) {

                            $suggestions[] = apply_filters( 'yith_wcas_suggestion', array(
                                'id'     => '',
                                'value'  => strip_tags( $product->get_title() ),
                                'url'    => $product->get_permalink(),
                                'image'  => $product->get_image('woocommerce_thumbnail'),
                                'price'  => $product->get_price_html(),
                            ), $product );
                        }
                    }
                }
                wp_reset_postdata();

                if ( $transient_enabled == 'yes' ) {
                    set_transient( $transient_name, $suggestions, $transient_duration * HOUR_IN_SECONDS );
                }
            }

            $time_end = $this->getmicrotime();
            $time = $time_end - $time_start;
            $suggestions = array(
                'suggestions' => $suggestions,
                'time'        => $time
            );
            echo json_encode( $suggestions );
            die();

        }
    }
}

$getbowtied_wcas = new Merchandiser_Predictive_Search();
