<?php

if (get_post_meta( Merchandiser::get_page_id(), 'footer_meta_box_check', true )) {
	$page_footer_option = get_post_meta( Merchandiser::get_page_id(), 'footer_meta_box_check', true );
} else {
	$page_footer_option = "on";
}

?>

<?php if ( $page_footer_option == "on" ) : ?>

	<?php if( is_active_sidebar( 'footer-widget-area' ) ) { ?>
		<div class="footer-widget-wrapper">
		    <ul class="footer-widget-area widget-area adjust_cols_height">
		        <?php dynamic_sidebar( 'footer-widget-area' ); ?>
		    </ul>
		</div>
	<?php } ?>

	<footer class="site-footer">

		<div class="footer-wrapper">

			<?php do_action( 'footer_socials' ); ?>

			<?php if ( !empty( Merchandiser_Options::getOption( 'footer_copyright' ) ) ) : ?>
				<div class="footer-copyright">
					<?php
					$text = Merchandiser_Options::getOption( 'footer_copyright' );
					echo do_shortcode(
						wp_kses(
							$text,
							array(
								'a'      => array(
									'href'  => array(),
									'title' => array(),
								),
								'br'     => array(),
								'em'     => array(),
								'strong' => array(),
								'img'	 => array(
									'alt' 				=> array(),
									'src' 				=> array(),
									'title' 			=> array(),
									'width' 			=> array(),
									'height' 			=> array(),
									'referrerpolicy'	=> array(),
									'crossorigin'		=> array(),
								),
							)
						)
					);
					?>
				</div>
			<?php endif; ?>

			<nav class="footer-navigation" >
				<?php
		            wp_nav_menu(array(
		                'theme_location' => 'footer',
		                'fallback_cb'    => false,
		                'container'      => false,
		                'items_wrap'     => '<ul class="%1$s">%3$s</ul>',
		            ));
		        ?>
			</nav>

		</div>

	</footer>

<?php endif; ?>
