<?php

/**
 * Add theme's custom body classes.
 *
 * @param [array] $classes Body classes.
 *
 * @return [array] Body classes.
 */
function merchandiser_add_custom_body_classes( $classes ) {

    // Sticky Header.
    if ( Merchandiser_Options::getOption( 'header_sticky', true ) ) {
        $classes[] = 'header-sticky';
    }

    // Sticky Footer.
    if ( Merchandiser_Options::getOption( 'footer_sticky', false ) ) {
        $classes[] = 'footer-sticky';
    }

    // Catalog Mode.
    if ( Merchandiser_Options::getOption( 'catalog_mode', false ) ) {
        $classes[] = 'catalog-mode';
    }

    // Page Without Title.
    $page_title_option_class            = '';
    $page_title_option_class_no_title   = 'page-without-title';

    if (get_post_meta( Merchandiser::get_page_id(), 'page_title_meta_box_check', true )) {
        $page_title_option = get_post_meta( Merchandiser::get_page_id(), 'page_title_meta_box_check', true );
        switch ( $page_title_option ) {
            case "off":
                $page_title_option_class = $page_title_option_class_no_title;
                break;
        }
    }
    $classes[] = $page_title_option_class;

    // Transparent Header.
    $header_transparent_class                   = '';
    $header_transparent_class_transparent       = 'header-transparent';
    $header_transparent_scheme_class            = '';
    $header_transparent_scheme_class_light      = 'header-transparent-light';
    $header_transparent_scheme_class_dark       = 'header-transparent-dark';

    // From Customizer.

    if ( Merchandiser_Options::getOption( 'header_transparent', false ) ) {

        $header_transparent_class = $header_transparent_class_transparent;

        switch ( Merchandiser_Options::getOption( 'header_transparent_scheme', 'dark' ) ) {

            case "light":
                $header_transparent_scheme_class = $header_transparent_scheme_class_light;
                break;
            case "dark":
                $header_transparent_scheme_class = $header_transparent_scheme_class_dark;
                break;
        }
    }

    if ( !MERCHANDISER_WOOCOMMERCE_IS_ACTIVE || !is_product_category() ) {

        // Overwrite From Page.

        if ( get_post_meta( Merchandiser::get_page_id(), 'page_header_transparency', true ) ) {

            $page_header_transparency = get_post_meta( Merchandiser::get_page_id(), 'page_header_transparency', true );

            switch ( $page_header_transparency ) {
                case "inherit":
                    $header_transparent_class           = $header_transparent_class;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class;
                    break;
                case "transparency_light":
                    $header_transparent_class           = $header_transparent_class_transparent;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class_light;
                    break;
                case "transparency_dark":
                    $header_transparent_class           = $header_transparent_class_transparent;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class_dark;
                    break;
                case "no_transparency":
                    $header_transparent_class           = '';
                    $header_transparent_scheme_class    = '';
                    break;
                default:
                    $header_transparent_class           = $header_transparent_class;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class;
                    break;
            }
        }
    }

    if (MERCHANDISER_WOOCOMMERCE_IS_ACTIVE && is_product_category()) {

        // Product Category.

        // if ( Merchandiser_Options::getOption( 'header_transparent', false ) ) {

            // $header_transparent_class = $header_transparent_class_transparent;

            switch ( Merchandiser_Options::getOption( 'category_transparency', 'inherit' ) ) {

                case "inherit":
                    $header_transparent_class           = $header_transparent_class;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class;
                    break;
                case "transparency_light":
                    $header_transparent_class           = $header_transparent_class_transparent;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class_light;
                    break;
                case "transparency_dark":
                    $header_transparent_class           = $header_transparent_class_transparent;
                    $header_transparent_scheme_class    = $header_transparent_scheme_class_dark;
                    break;
                case "no_transparency":
                    $header_transparent_class           = '';
                    $header_transparent_scheme_class    = '';
                    break;
            }
        // }
    }
    $classes[] = $header_transparent_class . " " . $header_transparent_scheme_class;

    return $classes;
}
add_action( 'body_class', 'merchandiser_add_custom_body_classes', 100 );
