<?php

/**
 * Enqueue theme styles.
 *
 * @return void
 */
function merchandiser_enqueue_theme_styles() {

	wp_enqueue_style( 'select2' );
	wp_enqueue_style( 'animate', get_template_directory_uri() . '/assets/css/vendor/animate.min.css', 		  	 array(), '3.5.1', 'all' );
	wp_enqueue_style( 'mmenu',   get_template_directory_uri() . '/assets/css/vendor/mmenu-oncanvas.min.css', 	 array(), '1.0.0', 'all' );
	wp_enqueue_style( 'swiper',  get_template_directory_uri() . '/assets/css/vendor/swiper.min.css', 			 	 array(), '6.4.1', 'all' );

	wp_enqueue_style( 'merchandiser-styles', get_template_directory_uri() . '/assets/css/styles.css', array(), Merchandiser::get_theme_version(), 'all' );
	wp_add_inline_style( 'merchandiser-styles', Merchandiser_Options::get_options_css() );

	wp_enqueue_style( 'merchandiser-default-styles', get_stylesheet_uri() );

	Merchandiser_Fonts::enqueue_theme_fonts();

	return;
}
add_action( 'wp_enqueue_scripts', 'merchandiser_enqueue_theme_styles', 99 );

/**
 * Enqueue theme admin styles.
 *
 * @return void
 */
function merchandiser_enqueue_theme_admin_styles() {
    if ( is_admin() ) {
		Merchandiser_Fonts::enqueue_theme_fonts();

		wp_enqueue_style( 'merchandiser-admin-styles', get_template_directory_uri() .'/assets/css/backend/wp-admin.css', array(), Merchandiser::get_theme_version(), 'all' );
		wp_add_inline_style( 'merchandiser-admin-styles', Merchandiser_Options::get_options_css() );
    }

	return;
}
add_action( 'admin_enqueue_scripts', 'merchandiser_enqueue_theme_admin_styles', 10 );
